/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins;

import com.gregtechceu.gtceu.client.model.SpriteOverrider;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.mojang.datafixers.util.Either;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockModel.class})
public class BlockModelMixin {
    @Shadow
    public String f_111416_;
    ThreadLocal<SpriteOverrider> spriteOverriderThreadLocal = new ThreadLocal();

    @Inject(method={"bake(Lnet/minecraft/client/resources/model/ModelBaker;Lnet/minecraft/client/renderer/block/model/BlockModel;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;Lnet/minecraft/resources/ResourceLocation;Z)Lnet/minecraft/client/resources/model/BakedModel;"}, at={@At(value="HEAD")})
    private void beforeBake(ModelBaker baker, BlockModel model, Function<Material, TextureAtlasSprite> spriteGetter, ModelState state, ResourceLocation location, boolean guiLight3d, CallbackInfoReturnable<BakedModel> cir) {
        if (spriteGetter instanceof SpriteOverrider) {
            SpriteOverrider spriteOverrider = (SpriteOverrider)spriteGetter;
            this.spriteOverriderThreadLocal.set(spriteOverrider);
        }
    }

    @Inject(method={"bake(Lnet/minecraft/client/resources/model/ModelBaker;Lnet/minecraft/client/renderer/block/model/BlockModel;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;Lnet/minecraft/resources/ResourceLocation;Z)Lnet/minecraft/client/resources/model/BakedModel;"}, at={@At(value="RETURN")})
    private void afterBake(ModelBaker baker, BlockModel model, Function<Material, TextureAtlasSprite> spriteGetter, ModelState state, ResourceLocation location, boolean guiLight3d, CallbackInfoReturnable<BakedModel> cir) {
        if (spriteGetter instanceof SpriteOverrider) {
            this.spriteOverriderThreadLocal.remove();
        }
    }

    @Inject(method={"findTextureEntry"}, at={@At(value="HEAD")}, cancellable=true)
    private void remapTextureEntry(String name, CallbackInfoReturnable<Either<Material, String>> cir) {
        ResourceLocation mat;
        SpriteOverrider overrider = this.spriteOverriderThreadLocal.get();
        if (overrider != null && overrider.override().containsKey(name) && (mat = overrider.override().get(name)) != null) {
            cir.setReturnValue((Object)ModelFactory.parseBlockTextureLocationOrReference((String)mat.toString()));
        }
    }
}

