/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.fluidpipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.pipenet.IMaterialPipeType;
import com.gregtechceu.gtceu.client.model.PipeModel;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;

public enum FluidPipeType implements IMaterialPipeType<FluidPipeProperties>
{
    TINY("tiny", 0.25f, 1, TagPrefix.pipeTinyFluid),
    SMALL("small", 0.375f, 2, TagPrefix.pipeSmallFluid),
    NORMAL("normal", 0.5f, 6, TagPrefix.pipeNormalFluid),
    LARGE("large", 0.75f, 12, TagPrefix.pipeLargeFluid),
    HUGE("huge", 0.875f, 24, TagPrefix.pipeHugeFluid),
    QUADRUPLE("quadruple", 0.95f, 2, TagPrefix.pipeQuadrupleFluid, 4),
    NONUPLE("nonuple", 0.95f, 2, TagPrefix.pipeNonupleFluid, 9);

    public static final ResourceLocation TYPE_ID;
    public final String name;
    public final float thickness;
    public final int capacityMultiplier;
    public final TagPrefix tagPrefix;
    public final int channels;

    private FluidPipeType(String name, float thickness, int capacityMultiplier, TagPrefix TagPrefix2) {
        this(name, thickness, capacityMultiplier, TagPrefix2, 1);
    }

    private FluidPipeType(String name, float thickness, int capacityMultiplier, TagPrefix TagPrefix2, int channels) {
        this.name = name;
        this.thickness = thickness;
        this.capacityMultiplier = capacityMultiplier;
        this.tagPrefix = TagPrefix2;
        this.channels = channels;
    }

    @Override
    public float getThickness() {
        return this.thickness;
    }

    @Override
    public FluidPipeProperties modifyProperties(FluidPipeProperties fluidPipeData) {
        return new FluidPipeProperties(fluidPipeData.getMaxFluidTemperature(), fluidPipeData.getThroughput() * this.capacityMultiplier, fluidPipeData.isGasProof(), fluidPipeData.isAcidProof(), fluidPipeData.isCryoProof(), fluidPipeData.isPlasmaProof(), this.channels);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public ResourceLocation type() {
        return TYPE_ID;
    }

    public PipeModel createPipeModel(Material material) {
        if (material.hasProperty(PropertyKey.WOOD)) {
            return new PipeModel(this.thickness, () -> GTCEu.id("block/pipe/pipe_side_wood"), () -> GTCEu.id("block/pipe/pipe_%s_in_wood".formatted(this.name)), null, null);
        }
        return new PipeModel(this.thickness, () -> GTCEu.id("block/pipe/pipe_side"), () -> GTCEu.id("block/pipe/pipe_%s_in".formatted(this.name)), null, null);
    }

    @Override
    @Generated
    public TagPrefix getTagPrefix() {
        return this.tagPrefix;
    }

    static {
        TYPE_ID = GTCEu.id("fluid");
    }
}

