/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.particle;

import com.gregtechceu.gtceu.common.data.GTParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public record HazardParticleOptions(int color, float scale) implements ParticleOptions
{
    public static final Codec<HazardParticleOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(particle -> particle.color), (App)Codec.FLOAT.fieldOf("scale").forGetter(particle -> Float.valueOf(particle.scale))).apply((Applicative)instance, HazardParticleOptions::new));
    public static final ParticleOptions.Deserializer<HazardParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<HazardParticleOptions>(){

        public HazardParticleOptions fromCommand(ParticleType<HazardParticleOptions> arg, StringReader stringReader) throws CommandSyntaxException {
            int color = stringReader.readInt();
            stringReader.expect(' ');
            float scale = stringReader.readFloat();
            return new HazardParticleOptions(color, scale);
        }

        public HazardParticleOptions fromNetwork(ParticleType<HazardParticleOptions> arg, FriendlyByteBuf arg2) {
            return new HazardParticleOptions(arg2.m_130242_(), arg2.readFloat());
        }
    };

    public ParticleType<?> m_6012_() {
        return (ParticleType)GTParticleTypes.HAZARD_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.color);
        buffer.writeFloat(this.scale);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.color, Float.valueOf(this.scale));
    }
}

