/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CrateMachine
extends MetaMachine
implements IUIMachine,
IMachineLife,
IDropSaveMachine,
IInteractedMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CrateMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    private final Material material;
    private final int inventorySize;
    @RequireRerender
    @Persisted
    @DescSynced
    private boolean isTaped;
    @Persisted
    public final NotifiableItemStackHandler inventory;

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public CrateMachine(IMachineBlockEntity holder, Material material, int inventorySize) {
        super(holder);
        this.material = material;
        this.inventorySize = inventorySize;
        this.inventory = new NotifiableItemStackHandler(this, inventorySize, IO.BOTH);
    }

    public ModularUI createUI(Player entityPlayer) {
        int xOffset = this.inventorySize >= 90 ? 162 : 0;
        int yOverflow = xOffset > 0 ? 18 : 9;
        int yOffset = this.inventorySize > 3 * yOverflow ? (this.inventorySize - 3 * yOverflow - (this.inventorySize - 3 * yOverflow) % yOverflow) / yOverflow * 18 : 0;
        ModularUI modularUI = new ModularUI(176 + xOffset, 166 + yOffset, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new LabelWidget(5, 5, this.getBlockState().m_60734_().m_7705_())).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT, 7 + xOffset / 2, 82 + yOffset, true));
        int x = 0;
        int y = 0;
        for (int slot = 0; slot < this.inventorySize; ++slot) {
            modularUI.widget((Widget)new SlotWidget(this.inventory, slot, x * 18 + 7, y * 18 + 17).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
            if (++x != yOverflow) continue;
            x = 0;
            ++y;
        }
        return modularUI;
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_() && !this.isTaped && (stack.m_150930_(GTItems.DUCT_TAPE.m_5456_()) || stack.m_150930_(GTItems.BASIC_TAPE.m_5456_()))) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.isTaped = true;
            return InteractionResult.SUCCESS;
        }
        return IInteractedMachine.super.onUse(state, world, pos, player, hand, hit);
    }

    @Override
    public void onMachinePlaced(@Nullable LivingEntity player, ItemStack stack) {
        IMachineLife.super.onMachinePlaced(player, stack);
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            boolean bl = this.isTaped = tag.m_128441_("taped") && tag.m_128471_("taped");
            if (this.isTaped) {
                this.inventory.storage.deserializeNBT(tag.m_128469_("inventory"));
            }
            tag.m_128473_("taped");
            this.isTaped = false;
        }
        stack.m_41751_(null);
    }

    @Override
    public void saveToItem(CompoundTag tag) {
        if (this.isTaped) {
            IDropSaveMachine.super.saveToItem(tag);
            tag.m_128379_("taped", this.isTaped);
            tag.m_128365_("inventory", (Tag)this.inventory.storage.serializeNBT());
        }
    }

    @Override
    public boolean saveBreak() {
        return this.isTaped;
    }

    @Override
    public void onMachineRemoved() {
        if (!this.isTaped) {
            this.clearInventory((IItemHandlerModifiable)this.inventory.storage);
        }
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public int getInventorySize() {
        return this.inventorySize;
    }

    @Generated
    public boolean isTaped() {
        return this.isTaped;
    }
}

