/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.owner;

import com.gregtechceu.gtceu.common.machine.owner.IMachineOwner;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.common.handlers.guild.GuildHandler;
import earth.terrarium.argonauts.common.handlers.guild.members.GuildMembers;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class ArgonautsOwner
implements IMachineOwner {
    private Guild guild;
    private UUID playerUUID;
    private MinecraftServer server;

    public ArgonautsOwner() {
    }

    public ArgonautsOwner(Guild guild, UUID player) {
        this.guild = guild;
        this.playerUUID = player;
        this.server = ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public void save(CompoundTag tag) {
        tag.m_128362_("guildUUID", this.guild.id());
        tag.m_128362_("playerUUID", this.playerUUID);
    }

    @Override
    public void load(CompoundTag tag) {
        this.playerUUID = tag.m_128342_("playerUUID");
        this.server = ServerLifecycleHooks.getCurrentServer();
        GuildHandler handler = GuildHandler.read((MinecraftServer)this.server);
        this.guild = GuildHandler.API.get(this.server, tag.m_128342_("guildUUID"));
    }

    @Override
    public boolean isPlayerInTeam(Player player) {
        if (player.m_20148_().equals(this.playerUUID)) {
            return true;
        }
        Guild otherGuild = GuildHandler.read((MinecraftServer)this.server).get(this.server, player.m_20148_());
        return otherGuild != null && otherGuild.equals(this.guild);
    }

    @Override
    public boolean isPlayerFriendly(Player player) {
        if (this.guild.isPublic()) {
            return true;
        }
        if (((GuildMembers)this.guild.members()).isMember(player.m_20148_())) {
            return true;
        }
        if (((GuildMembers)this.guild.members()).isInvited(player.m_20148_())) {
            return true;
        }
        return ((GuildMembers)this.guild.members()).isAllied(player.m_20148_());
    }

    @Override
    public UUID getUUID() {
        return this.guild.id();
    }

    @Override
    public String getName() {
        return this.guild.displayName().getString();
    }

    @Override
    public void displayInfo(List<Component> compList) {
        boolean isOnline;
        compList.add((Component)Component.m_237110_((String)"behavior.portable_scanner.machine_ownership", (Object[])new Object[]{this.type().getName()}));
        compList.add((Component)Component.m_237110_((String)"behavior.portable_scanner.guild_name", (Object[])new Object[]{this.guild.displayName().getString()}));
        ServerPlayer serverPlayer = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.playerUUID);
        String[] playerName = new String[1];
        if (serverPlayer != null) {
            playerName[0] = serverPlayer.m_5446_().getString();
            isOnline = true;
        } else {
            GameProfileCache cache = ServerLifecycleHooks.getCurrentServer().m_129927_();
            if (cache != null) {
                cache.m_11002_(this.playerUUID).ifPresent(value -> {
                    playerName[0] = value.getName();
                });
            }
            isOnline = false;
        }
        compList.add((Component)Component.m_237110_((String)"behavior.portable_scanner.player_name", (Object[])new Object[]{playerName[0], isOnline}));
    }

    @Override
    public IMachineOwner.MachineOwnerType type() {
        return IMachineOwner.MachineOwnerType.ARGONAUTS;
    }

    @Generated
    public Guild getGuild() {
        return this.guild;
    }

    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }
}

