/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part.hpca;

import com.gregtechceu.gtceu.api.capability.IHPCAComponentHatch;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class HPCAComponentPartMachine
extends MultiblockPartMachine
implements IHPCAComponentHatch,
IMachineModifyDrops {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(HPCAComponentPartMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    private boolean damaged;

    public HPCAComponentPartMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    public abstract boolean isAdvanced();

    public boolean doesAllowBridging() {
        return false;
    }

    @Override
    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return false;
    }

    @Override
    public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Override
    public boolean canShared() {
        return false;
    }

    @Override
    public final boolean isBridge() {
        return this.doesAllowBridging() && (!this.canBeDamaged() || !this.isDamaged());
    }

    @Override
    public boolean replacePartModelWhenFormed() {
        return false;
    }

    @Override
    public boolean isDamaged() {
        return this.canBeDamaged() && this.damaged;
    }

    @Override
    public void setDamaged(boolean damaged) {
        if (!this.canBeDamaged()) {
            return;
        }
        if (this.damaged != damaged) {
            this.damaged = damaged;
            this.markDirty();
        }
    }

    @Override
    public void onDrops(List<ItemStack> drops) {
        for (int i = 0; i < drops.size(); ++i) {
            ItemStack drop = drops.get(i);
            if (drop.m_41720_() != this.getDefinition().getItem()) continue;
            if (!this.canBeDamaged() || !this.isDamaged()) break;
            if (this.isAdvanced()) {
                drops.set(i, GTBlocks.ADVANCED_COMPUTER_CASING.asStack());
                break;
            }
            drops.set(i, GTBlocks.COMPUTER_CASING.asStack());
            break;
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }
}

