/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.widget.PhantomFluidWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.CircuitFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IHasCircuitSlot;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidHatchPartMachine
extends TieredIOPartMachine
implements IMachineLife,
IHasCircuitSlot {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FluidHatchPartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    public static final int INITIAL_TANK_CAPACITY_1X = 8000;
    public static final int INITIAL_TANK_CAPACITY_4X = 2000;
    public static final int INITIAL_TANK_CAPACITY_9X = 1000;
    @Persisted
    public final NotifiableFluidTank tank;
    private final int slots;
    @Nullable
    protected TickableSubscription autoIOSubs;
    @Nullable
    protected ISubscription tankSubs;
    @Persisted
    protected final NotifiableItemStackHandler circuitInventory;

    public FluidHatchPartMachine(IMachineBlockEntity holder, int tier, IO io, int initialCapacity, int slots, Object ... args) {
        super(holder, tier, io);
        this.slots = slots;
        this.tank = this.createTank(initialCapacity, slots, args);
        this.circuitInventory = this.createCircuitItemHandler(io);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createTank(int initialCapacity, int slots, Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, slots, FluidHatchPartMachine.getTankCapacity(initialCapacity, this.getTier()), this.io);
    }

    public static int getTankCapacity(int initialCapacity, int tier) {
        return initialCapacity * (1 << Math.min(9, tier));
    }

    protected NotifiableItemStackHandler createCircuitItemHandler(Object ... args) {
        IO io;
        Object object;
        if (args.length > 0 && (object = args[0]) instanceof IO && (io = (IO)object) == IO.IN) {
            return new NotifiableItemStackHandler(this, 1, IO.IN, IO.NONE).setFilter(IntCircuitBehaviour::isIntegratedCircuit);
        }
        return new NotifiableItemStackHandler(this, 0, IO.NONE);
    }

    @Override
    public void onMachineRemoved() {
        if (!ConfigHolder.INSTANCE.machines.ghostCircuit) {
            this.clearInventory((IItemHandlerModifiable)this.circuitInventory.storage);
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateTankSubscription));
        }
        this.tankSubs = this.tank.addChangedListener(this::updateTankSubscription);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.tankSubs != null) {
            this.tankSubs.unsubscribe();
            this.tankSubs = null;
        }
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateTankSubscription();
    }

    @Override
    public void onRotated(Direction oldFacing, Direction newFacing) {
        super.onRotated(oldFacing, newFacing);
        this.updateTankSubscription();
    }

    protected void updateTankSubscription() {
        if (this.isWorkingEnabled() && (this.io == IO.OUT && !this.tank.isEmpty() || this.io == IO.IN) && GTTransferUtils.hasAdjacentFluidHandler(this.getLevel(), this.getPos(), this.getFrontFacing())) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    protected void autoIO() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isWorkingEnabled()) {
                if (this.io == IO.OUT) {
                    this.tank.exportToNearby(this.getFrontFacing());
                } else if (this.io == IO.IN) {
                    this.tank.importFromNearby(this.getFrontFacing());
                }
            }
            this.updateTankSubscription();
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.updateTankSubscription();
    }

    @Override
    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        if (this.io == IO.IN) {
            configuratorPanel.attachConfigurators(new CircuitFancyConfigurator(this.circuitInventory.storage));
        }
    }

    @Override
    public Widget createUIWidget() {
        if (this.slots == 1) {
            return this.createSingleSlotGUI();
        }
        return this.createMultiSlotGUI();
    }

    protected Widget createSingleSlotGUI() {
        TankWidget tankWidget;
        WidgetGroup group = new WidgetGroup(0, 0, 89, 63);
        group.addWidget((Widget)new ImageWidget(4, 4, 81, 55, (IGuiTexture)GuiTextures.DISPLAY));
        if (this.io == IO.OUT) {
            tankWidget = new PhantomFluidWidget((IFluidHandler)this.tank.getLockedFluid(), 0, 67, 40, 18, 18, () -> this.tank.getLockedFluid().getFluid(), f -> {
                if (!this.tank.getFluidInTank(0).isEmpty()) {
                    return;
                }
                if (f == null || f.isEmpty()) {
                    this.tank.setLocked(false);
                } else {
                    FluidStack newFluid = f.copy();
                    newFluid.setAmount(1);
                    this.tank.setLocked(true, newFluid);
                }
            }).setShowAmount(false).setDrawHoverTips(true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT);
            group.addWidget((Widget)tankWidget);
            group.addWidget((Widget)new ToggleButtonWidget(7, 40, 18, 18, (IGuiTexture)GuiTextures.BUTTON_LOCK, this.tank::isLocked, this.tank::setLocked).setTooltipText("gtceu.gui.fluid_lock.tooltip").setShouldUseBaseBackground()).addWidget((Widget)new TankWidget(this.tank.getStorages()[0], 67, 22, 18, 18, true, this.io.support(IO.IN)).setShowAmount(true).setDrawHoverTips(true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
        } else {
            tankWidget = new TankWidget(this.tank.getStorages()[0], 67, 22, 18, 18, true, this.io.support(IO.IN)).setShowAmount(true).setDrawHoverTips(true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT);
            group.addWidget((Widget)tankWidget);
        }
        group.addWidget((Widget)new LabelWidget(8, 8, "gtceu.gui.fluid_amount")).addWidget((Widget)new LabelWidget(8, 18, () -> this.getFluidAmountText(tankWidget))).addWidget((Widget)new LabelWidget(8, 28, () -> this.getFluidNameText(tankWidget).getString()));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    private Component getFluidNameText(TankWidget tankWidget) {
        Component translation = !this.tank.getFluidInTank(tankWidget.getTank()).isEmpty() ? this.tank.getFluidInTank(tankWidget.getTank()).getDisplayName() : this.tank.getLockedFluid().getFluid().getDisplayName();
        return translation;
    }

    private String getFluidAmountText(TankWidget tankWidget) {
        String fluidAmount = "";
        if (!this.tank.getFluidInTank(tankWidget.getTank()).isEmpty()) {
            fluidAmount = this.getFormattedFluidAmount(this.tank.getFluidInTank(tankWidget.getTank()));
        } else if (!this.tank.getLockedFluid().getFluid().isEmpty()) {
            fluidAmount = "0";
        }
        return fluidAmount;
    }

    public String getFormattedFluidAmount(FluidStack fluidStack) {
        return String.format("%,d", fluidStack.isEmpty() ? 0 : fluidStack.getAmount());
    }

    protected Widget createMultiSlotGUI() {
        int rowSize;
        int colSize = rowSize = (int)Math.sqrt(this.slots);
        if (this.slots == 8) {
            rowSize = 4;
            colSize = 2;
        }
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize + 16, 18 * colSize + 16);
        WidgetGroup container = new WidgetGroup(4, 4, 18 * rowSize + 8, 18 * colSize + 8);
        int index = 0;
        for (int y = 0; y < colSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                container.addWidget((Widget)new TankWidget(this.tank.getStorages()[index++], 4 + x * 18, 4 + y * 18, true, this.io.support(IO.IN)).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
            }
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Override
    @Generated
    public NotifiableItemStackHandler getCircuitInventory() {
        return this.circuitInventory;
    }
}

