/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric.research;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationHatch;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableComputationContainer;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.research.DataBankMachine;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class NetworkSwitchMachine
extends DataBankMachine
implements IOpticalComputationProvider {
    public static final int EUT_PER_HATCH = GTValues.VA[5];
    private final MultipleComputationHandler computationHandler = new MultipleComputationHandler(this);

    public NetworkSwitchMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    protected int calculateEnergyUsage() {
        int receivers = 0;
        int transmitters = 0;
        for (IMultiPart part : this.getParts()) {
            Block block = part.self().getBlockState().m_60734_();
            if (PartAbility.COMPUTATION_DATA_RECEPTION.isApplicable(block)) {
                ++receivers;
            }
            if (!PartAbility.COMPUTATION_DATA_TRANSMISSION.isApplicable(block)) continue;
            ++transmitters;
        }
        return GTValues.VA[5] * (receivers + transmitters);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        ArrayList<IOpticalComputationHatch> receivers = new ArrayList<IOpticalComputationHatch>();
        ArrayList<IOpticalComputationHatch> transmitters = new ArrayList<IOpticalComputationHatch>();
        for (IMultiPart part : this.getParts()) {
            if (part instanceof IOpticalComputationHatch) {
                IOpticalComputationHatch hatch = (IOpticalComputationHatch)((Object)part);
                Block block = part.self().getBlockState().m_60734_();
                if (PartAbility.COMPUTATION_DATA_RECEPTION.isApplicable(block)) {
                    receivers.add(hatch);
                }
                if (!PartAbility.COMPUTATION_DATA_TRANSMISSION.isApplicable(block)) continue;
                transmitters.add(hatch);
                continue;
            }
            if (!part.getRecipeHandlers().stream().anyMatch(IOpticalComputationHatch.class::isInstance)) continue;
            IOpticalComputationHatch hatch = part.getRecipeHandlers().stream().filter(IOpticalComputationHatch.class::isInstance).map(IOpticalComputationHatch.class::cast).findFirst().orElse(null);
            if (hatch == null) continue;
            Block block = part.self().getBlockState().m_60734_();
            if (PartAbility.COMPUTATION_DATA_RECEPTION.isApplicable(block)) {
                receivers.add(hatch);
            }
            if (!PartAbility.COMPUTATION_DATA_TRANSMISSION.isApplicable(block)) continue;
            transmitters.add(hatch);
        }
        this.computationHandler.onStructureForm(receivers, transmitters);
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.computationHandler.reset();
    }

    @Override
    public int getEnergyUsage() {
        return this.isFormed() ? this.computationHandler.getEUt() : 0;
    }

    @Override
    public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isActive() && !this.getRecipeLogic().isWaiting() ? this.computationHandler.requestCWUt(cwut, simulate, seen) : 0;
    }

    @Override
    public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isFormed() ? this.computationHandler.getMaxCWUt(seen) : 0;
    }

    @Override
    public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return true;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        MultiblockDisplayText.builder(textList, this.isFormed()).setWorkingStatus(true, this.isActive() && this.isWorkingEnabled()).setWorkingStatusKeys("gtceu.multiblock.idling", "gtceu.multiblock.idling", "gtceu.multiblock.data_bank.providing").addEnergyUsageExactLine(this.getEnergyUsage()).addComputationUsageLine(this.computationHandler.getMaxCWUtForDisplay()).addWorkingStatusLine();
    }

    private static class MultipleComputationHandler
    extends NotifiableComputationContainer {
        private final Set<IOpticalComputationHatch> providers = new ObjectOpenHashSet();
        private final Set<IOpticalComputationHatch> transmitters = new ObjectOpenHashSet();
        private int EUt;

        public MultipleComputationHandler(MetaMachine machine) {
            super(machine, IO.IN, false);
        }

        private void onStructureForm(Collection<IOpticalComputationHatch> providers, Collection<IOpticalComputationHatch> transmitters) {
            this.reset();
            this.providers.addAll(providers);
            this.transmitters.addAll(transmitters);
            this.EUt = (providers.size() + transmitters.size()) * EUT_PER_HATCH;
        }

        private void reset() {
            this.providers.clear();
            this.transmitters.clear();
            this.EUt = 0;
        }

        @Override
        public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
            if (seen.contains(this)) {
                return 0;
            }
            seen.add(this);
            ArrayList<IOpticalComputationProvider> bridgeSeen = new ArrayList<IOpticalComputationProvider>(seen);
            int allocatedCWUt = 0;
            for (IOpticalComputationHatch provider : this.providers) {
                if (!provider.canBridge(bridgeSeen)) continue;
                int allocated = provider.requestCWUt(cwut, simulate, seen);
                allocatedCWUt += allocated;
                if ((cwut -= allocated) != 0) continue;
                break;
            }
            return allocatedCWUt;
        }

        public int getMaxCWUtForDisplay() {
            ArrayList<IOpticalComputationProvider> seen = new ArrayList<IOpticalComputationProvider>();
            seen.add(this);
            ArrayList<IOpticalComputationProvider> bridgeSeen = new ArrayList<IOpticalComputationProvider>(seen);
            int maximumCWUt = 0;
            for (IOpticalComputationHatch provider : this.providers) {
                if (!provider.canBridge(bridgeSeen)) continue;
                maximumCWUt += provider.getMaxCWUt(seen);
            }
            return maximumCWUt;
        }

        @Override
        public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
            if (seen.contains(this)) {
                return 0;
            }
            seen.add(this);
            ArrayList<IOpticalComputationProvider> bridgeSeen = new ArrayList<IOpticalComputationProvider>(seen);
            int maximumCWUt = 0;
            for (IOpticalComputationHatch provider : this.providers) {
                if (!provider.canBridge(bridgeSeen)) continue;
                maximumCWUt += provider.getMaxCWUt(seen);
            }
            return maximumCWUt;
        }

        @Override
        public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
            if (seen.contains(this)) {
                return false;
            }
            seen.add(this);
            for (IOpticalComputationHatch provider : this.providers) {
                if (!provider.canBridge(seen)) continue;
                return true;
            }
            return false;
        }

        private boolean hasNonBridgingConnections() {
            ArrayList<IOpticalComputationProvider> seen = new ArrayList<IOpticalComputationProvider>();
            for (IOpticalComputationHatch provider : this.providers) {
                if (provider.canBridge(seen)) continue;
                return true;
            }
            return false;
        }

        @Override
        public IOpticalComputationProvider getComputationProvider() {
            return this;
        }

        @Generated
        private int getEUt() {
            return this.EUt;
        }
    }
}

