/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric.research;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.config.ConfigHolder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DataBankMachine
extends WorkableElectricMultiblockMachine
implements IFancyUIMachine,
IDisplayUIMachine,
IControllable {
    public static final int EUT_PER_HATCH = GTValues.VA[4];
    public static final int EUT_PER_HATCH_CHAINED = GTValues.VA[6];
    private IMaintenanceMachine maintenance;
    private IEnergyContainer energyContainer = new EnergyContainerList(new ArrayList());
    private int energyUsage = 0;
    @Nullable
    protected TickableSubscription tickSubs;

    public DataBankMachine(IMachineBlockEntity holder) {
        super(holder, new Object[0]);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        ArrayList<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
        Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            IO io = ioMap.getOrDefault(part.self().getPos().m_121878_(), IO.BOTH);
            if (part instanceof IMaintenanceMachine) {
                IMaintenanceMachine maintenanceMachine;
                this.maintenance = maintenanceMachine = (IMaintenanceMachine)part;
            }
            if (io == IO.NONE || io == IO.OUT) continue;
            for (IRecipeHandlerTrait handler : part.getRecipeHandlers()) {
                if (io != IO.BOTH && handler.getHandlerIO() != IO.BOTH && io != handler.getHandlerIO() || handler.getCapability() != EURecipeCapability.CAP || !(handler instanceof IEnergyContainer)) continue;
                IEnergyContainer container = (IEnergyContainer)((Object)handler);
                energyContainers.add(container);
            }
        }
        this.energyContainer = new EnergyContainerList(energyContainers);
        this.energyUsage = this.calculateEnergyUsage();
        if (this.maintenance == null) {
            this.onStructureInvalid();
            return;
        }
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateTickSubscription));
        }
    }

    protected int calculateEnergyUsage() {
        int receivers = 0;
        int transmitters = 0;
        int regulars = 0;
        for (IMultiPart part : this.getParts()) {
            Block block = part.self().getBlockState().m_60734_();
            if (PartAbility.OPTICAL_DATA_RECEPTION.isApplicable(block)) {
                ++receivers;
            }
            if (PartAbility.OPTICAL_DATA_TRANSMISSION.isApplicable(block)) {
                ++transmitters;
            }
            if (!PartAbility.DATA_ACCESS.isApplicable(block)) continue;
            ++regulars;
        }
        int dataHatches = receivers + transmitters + regulars;
        int eutPerHatch = receivers > 0 ? EUT_PER_HATCH_CHAINED : EUT_PER_HATCH;
        return eutPerHatch * dataHatches;
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.energyContainer = new EnergyContainerList(new ArrayList());
        this.energyUsage = 0;
    }

    @Override
    public void onLoad() {
        Level level;
        super.onLoad();
        if (this.isFormed() && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateTickSubscription));
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    protected void updateTickSubscription() {
        if (this.isFormed) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tick);
        } else if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    public void tick() {
        boolean hasMaintenance;
        int energyToConsume = this.getEnergyUsage();
        boolean bl = hasMaintenance = ConfigHolder.INSTANCE.machines.enableMaintenance && this.maintenance != null;
        if (hasMaintenance) {
            energyToConsume += this.maintenance.getNumMaintenanceProblems() * energyToConsume / 10;
        }
        if (this.getRecipeLogic().isWaiting() && this.energyContainer.getInputPerSec() > 19L * (long)energyToConsume) {
            this.getRecipeLogic().setStatus(RecipeLogic.Status.IDLE);
        }
        if (this.energyContainer.getEnergyStored() >= (long)energyToConsume) {
            if (!this.getRecipeLogic().isWaiting()) {
                long consumed = this.energyContainer.removeEnergy(energyToConsume);
                if (consumed == (long)energyToConsume) {
                    this.getRecipeLogic().setStatus(RecipeLogic.Status.WORKING);
                } else {
                    this.getRecipeLogic().setWaiting((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_in").m_130946_(": ").m_7220_(EURecipeCapability.CAP.getName()));
                }
            }
        } else {
            this.getRecipeLogic().setWaiting((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_in").m_130946_(": ").m_7220_(EURecipeCapability.CAP.getName()));
        }
        this.updateTickSubscription();
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        MultiblockDisplayText.builder(textList, this.isFormed()).setWorkingStatus(true, this.isActive() && this.isWorkingEnabled()).setWorkingStatusKeys("gtceu.multiblock.idling", "gtceu.multiblock.idling", "gtceu.multiblock.data_bank.providing").addEnergyUsageExactLine(this.getEnergyUsage()).addWorkingStatusLine();
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public int getMaxProgress() {
        return 0;
    }

    @Generated
    public int getEnergyUsage() {
        return this.energyUsage;
    }
}

