/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric.gcym;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LargeMixerMachine
extends WorkableElectricMultiblockMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LargeMixerMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    @DescSynced
    @RequireRerender
    private final Set<BlockPos> fluidBlockOffsets = new HashSet<BlockPos>();

    public LargeMixerMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.saveOffsets();
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.fluidBlockOffsets.clear();
    }

    protected void saveOffsets() {
        Direction counterClockWise;
        Direction clockWise;
        Direction up = RelativeDirection.UP.getRelativeFacing(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        Direction back = this.getFrontFacing().m_122424_();
        if (up == Direction.UP || up == Direction.DOWN) {
            clockWise = this.getFrontFacing().m_122427_();
            counterClockWise = this.getFrontFacing().m_122428_();
        } else {
            clockWise = Direction.UP;
            counterClockWise = Direction.DOWN;
        }
        BlockPos pos = this.getPos();
        BlockPos center = pos.m_5484_(up, 3);
        for (int i = 0; i < 3; ++i) {
            center = center.m_121945_(back);
            if (i % 2 == 0) {
                this.fluidBlockOffsets.add(center.m_121996_((Vec3i)pos));
            }
            this.fluidBlockOffsets.add(center.m_121945_(clockWise).m_121996_((Vec3i)pos));
            this.fluidBlockOffsets.add(center.m_121945_(counterClockWise).m_121996_((Vec3i)pos));
        }
    }

    @Generated
    public Set<BlockPos> getFluidBlockOffsets() {
        return this.fluidBlockOffsets;
    }
}

