/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IFusionCasingType;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.common.block.FusionCasingBlock;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FusionReactorMachine
extends WorkableElectricMultiblockMachine
implements ITieredMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FusionReactorMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    public static final OverclockingLogic FUSION_OC = OverclockingLogic.create(0.5, 2.0, false);
    private static final TreeMap<Long, Integer> FUSION_ENERGY = new TreeMap();
    private static final Int2ObjectMap<String> FUSION_NAMES = new Int2ObjectOpenHashMap(4);
    private static int MINIMUM_TIER = 14;
    private final int tier;
    @Nullable
    protected EnergyContainerList inputEnergyContainers;
    @Persisted
    protected long heat = 0L;
    @Persisted
    protected final NotifiableEnergyContainer energyContainer;
    @DescSynced
    private Integer color = -1;
    @Nullable
    protected TickableSubscription preHeatSubs;

    public FusionReactorMachine(IMachineBlockEntity holder, int tier) {
        super(holder, new Object[0]);
        this.tier = tier;
        this.energyContainer = this.createEnergyContainer();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public NotifiableEnergyContainer createEnergyContainer() {
        NotifiableEnergyContainer container = new NotifiableEnergyContainer(this, 0L, 0L, 0L, 0L, 0L);
        container.setCapabilityValidator(Objects::isNull);
        return container;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.updatePreHeatSubscription();
        }
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        ArrayList<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
        Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            IO io = ioMap.getOrDefault(part.self().getPos().m_121878_(), IO.BOTH);
            if (io == IO.NONE || io == IO.OUT) continue;
            for (IRecipeHandlerTrait handler : part.getRecipeHandlers()) {
                if (io != IO.BOTH && handler.getHandlerIO() != IO.BOTH && io != handler.getHandlerIO() || handler.getCapability() != EURecipeCapability.CAP || !(handler instanceof IEnergyContainer)) continue;
                IEnergyContainer container = (IEnergyContainer)((Object)handler);
                energyContainers.add(container);
                this.traitSubscriptions.add(handler.addChangedListener(this::updatePreHeatSubscription));
            }
        }
        this.inputEnergyContainers = new EnergyContainerList(energyContainers);
        this.energyContainer.resetBasicInfo(FusionReactorMachine.calculateEnergyStorageFactor(this.getTier(), energyContainers.size()), 0L, 0L, 0L, 0L);
        this.updatePreHeatSubscription();
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.inputEnergyContainers = null;
        this.heat = 0L;
        this.energyContainer.resetBasicInfo(0L, 0L, 0L, 0L, 0L);
        this.energyContainer.setEnergyStored(0L);
        this.updatePreHeatSubscription();
    }

    protected void updatePreHeatSubscription() {
        if (this.heat > 0L || this.inputEnergyContainers != null && this.inputEnergyContainers.getEnergyStored() > 0L && this.energyContainer.getEnergyStored() < this.energyContainer.getEnergyCapacity()) {
            this.preHeatSubs = this.subscribeServerTick(this.preHeatSubs, this::updateHeat);
        } else if (this.preHeatSubs != null) {
            this.preHeatSubs.unsubscribe();
            this.preHeatSubs = null;
        }
    }

    public static ModifierFunction recipeModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof FusionReactorMachine)) {
            return RecipeModifier.nullWrongType(FusionReactorMachine.class, machine);
        }
        FusionReactorMachine fusionReactorMachine = (FusionReactorMachine)machine;
        if (RecipeHelper.getRecipeEUtTier(recipe) > fusionReactorMachine.getTier() || !recipe.data.m_128441_("eu_to_start") || recipe.data.m_128454_("eu_to_start") > fusionReactorMachine.energyContainer.getEnergyCapacity()) {
            return ModifierFunction.NULL;
        }
        long heatDiff = recipe.data.m_128454_("eu_to_start") - fusionReactorMachine.heat;
        if (heatDiff <= 0L) {
            return FUSION_OC.getModifier(machine, recipe, fusionReactorMachine.getMaxVoltage(), false);
        }
        if (fusionReactorMachine.energyContainer.getEnergyStored() < heatDiff) {
            return ModifierFunction.NULL;
        }
        fusionReactorMachine.energyContainer.removeEnergy(heatDiff);
        fusionReactorMachine.heat += heatDiff;
        fusionReactorMachine.updatePreHeatSubscription();
        return FUSION_OC.getModifier(machine, recipe, fusionReactorMachine.getMaxVoltage(), false);
    }

    @Override
    public boolean alwaysTryModifyRecipe() {
        return true;
    }

    @Override
    public boolean onWorking() {
        FluidStack stack;
        int newColor;
        long heatDiff;
        GTRecipe recipe = this.recipeLogic.getLastRecipe();
        if (recipe.data.m_128441_("eu_to_start") && (heatDiff = recipe.data.m_128454_("eu_to_start") - this.heat) > 0L) {
            this.recipeLogic.setWaiting((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_fuel"));
            if (this.energyContainer.getEnergyStored() < heatDiff) {
                return super.onWorking();
            }
            this.energyContainer.removeEnergy(heatDiff);
            this.heat += heatDiff;
            this.updatePreHeatSubscription();
        }
        if (this.color == -1 && !recipe.getOutputContents(FluidRecipeCapability.CAP).isEmpty() && !Objects.equals(this.color, newColor = 0xFF000000 | GTUtil.getFluidColor(stack = ((FluidIngredient)FluidRecipeCapability.CAP.of(recipe.getOutputContents(FluidRecipeCapability.CAP).get(0).getContent())).getStacks()[0]))) {
            this.color = newColor;
        }
        return super.onWorking();
    }

    public void updateHeat() {
        if ((this.getRecipeLogic().isIdle() || !this.isWorkingEnabled() || this.getRecipeLogic().isWaiting() && this.getRecipeLogic().getProgress() == 0) && this.heat > 0L) {
            this.heat = this.heat <= 10000L ? 0L : this.heat - 10000L;
        }
        long leftStorage = this.energyContainer.getEnergyCapacity() - this.energyContainer.getEnergyStored();
        if (this.inputEnergyContainers != null && leftStorage > 0L) {
            this.energyContainer.addEnergy(this.inputEnergyContainers.removeEnergy(leftStorage));
        }
        this.updatePreHeatSubscription();
    }

    @Override
    public void onWaiting() {
        super.onWaiting();
        this.color = -1;
    }

    @Override
    public void afterWorking() {
        super.afterWorking();
        this.color = -1;
    }

    @Override
    public long getMaxVoltage() {
        return Math.min(GTValues.V[this.tier], super.getMaxVoltage());
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        super.addDisplayText(textList);
        if (this.isFormed()) {
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.fusion_reactor.energy", (Object[])new Object[]{this.energyContainer.getEnergyStored(), this.energyContainer.getEnergyCapacity()}));
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.fusion_reactor.heat", (Object[])new Object[]{this.heat}));
        }
    }

    public static void addEUToStartLabel(GTRecipe recipe, WidgetGroup group) {
        long euToStart = recipe.data.m_128454_("eu_to_start");
        if (euToStart <= 0L) {
            return;
        }
        int recipeTier = RecipeHelper.getPreOCRecipeEuTier(recipe);
        int fusionTier = FUSION_ENERGY.ceilingEntry(euToStart).getValue();
        int tier = Math.max(MINIMUM_TIER, Math.max(recipeTier, fusionTier));
        group.addWidget((Widget)new LabelWidget(-8, group.getSizeHeight() - 10, LocalizationUtils.format((String)"gtceu.recipe.eu_to_start", (Object[])new Object[]{FormattingUtil.formatNumberReadable2F(euToStart, false), FUSION_NAMES.get(tier)})));
    }

    public static void registerFusionTier(int tier, @NotNull String name) {
        long maxEU = FusionReactorMachine.calculateEnergyStorageFactor(tier, 16);
        FUSION_ENERGY.put(maxEU, tier);
        FUSION_NAMES.put(tier, (Object)name);
        MINIMUM_TIER = Math.min(tier, MINIMUM_TIER);
    }

    public static long calculateEnergyStorageFactor(int tier, int energyInputAmount) {
        return (long)energyInputAmount * (long)Math.pow(2.0, tier - 6) * 10000000L;
    }

    public static Block getCasingState(int tier) {
        return switch (tier) {
            case 6 -> (FusionCasingBlock)GTBlocks.FUSION_CASING.get();
            case 7 -> (FusionCasingBlock)GTBlocks.FUSION_CASING_MK2.get();
            default -> (FusionCasingBlock)GTBlocks.FUSION_CASING_MK3.get();
        };
    }

    public static Block getCoilState(int tier) {
        if (tier == 6) {
            return (Block)GTBlocks.SUPERCONDUCTING_COIL.get();
        }
        return (Block)GTBlocks.FUSION_COIL.get();
    }

    public static IFusionCasingType getCasingType(int tier) {
        return switch (tier) {
            case 6 -> FusionCasingBlock.CasingType.FUSION_CASING;
            case 7 -> FusionCasingBlock.CasingType.FUSION_CASING_MK2;
            case 8 -> FusionCasingBlock.CasingType.FUSION_CASING_MK3;
            default -> FusionCasingBlock.CasingType.FUSION_CASING;
        };
    }

    @Override
    @Generated
    public int getTier() {
        return this.tier;
    }

    @Generated
    public Integer getColor() {
        return this.color;
    }
}

