/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ActiveTransformerMachine
extends WorkableElectricMultiblockMachine
implements IControllable,
IExplosionMachine,
IFancyUIMachine,
IDisplayUIMachine {
    private IEnergyContainer powerOutput = new EnergyContainerList(new ArrayList());
    private IEnergyContainer powerInput = new EnergyContainerList(new ArrayList());
    protected ConditionalSubscriptionHandler converterSubscription = new ConditionalSubscriptionHandler(this, this::convertEnergyTick, this::isSubscriptionActive);

    public ActiveTransformerMachine(IMachineBlockEntity holder) {
        super(holder, new Object[0]);
    }

    public void convertEnergyTick() {
        if (this.isWorkingEnabled()) {
            this.getRecipeLogic().setStatus(this.isSubscriptionActive() ? RecipeLogic.Status.WORKING : RecipeLogic.Status.SUSPEND);
        }
        if (this.isWorkingEnabled()) {
            long canDrain = this.powerInput.getEnergyStored();
            long totalDrained = this.powerOutput.changeEnergy(canDrain);
            this.powerInput.removeEnergy(totalDrained);
        }
        this.converterSubscription.updateSubscription();
    }

    protected boolean isSubscriptionActive() {
        if (!this.isFormed()) {
            return false;
        }
        if (this.powerInput == null || this.powerInput.getEnergyStored() <= 0L) {
            return false;
        }
        if (this.powerOutput == null) {
            return false;
        }
        return this.powerOutput.getEnergyStored() < this.powerOutput.getEnergyCapacity();
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        ArrayList<IEnergyContainer> powerInput = new ArrayList<IEnergyContainer>();
        ArrayList<IEnergyContainer> powerOutput = new ArrayList<IEnergyContainer>();
        Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getPrioritySortedParts()) {
            IO io = ioMap.getOrDefault(part.self().getPos().m_121878_(), IO.BOTH);
            if (io == IO.NONE) continue;
            for (IRecipeHandlerTrait handler : part.getRecipeHandlers()) {
                IO handlerIO = handler.getHandlerIO();
                if (io != IO.BOTH && handlerIO != IO.BOTH && io != handlerIO || handler.getCapability() != EURecipeCapability.CAP || !(handler instanceof IEnergyContainer)) continue;
                IEnergyContainer container = (IEnergyContainer)((Object)handler);
                if (handlerIO == IO.IN) {
                    powerInput.add(container);
                } else if (handlerIO == IO.OUT) {
                    powerOutput.add(container);
                }
                this.traitSubscriptions.add(handler.addChangedListener(this.converterSubscription::updateSubscription));
            }
        }
        if (powerInput.isEmpty() || powerOutput.isEmpty()) {
            this.onStructureInvalid();
        }
        this.powerOutput = new EnergyContainerList(powerOutput);
        this.powerInput = new EnergyContainerList(powerInput);
        this.converterSubscription.updateSubscription();
    }

    @NotNull
    private List<IMultiPart> getPrioritySortedParts() {
        return this.getParts().stream().sorted(Comparator.comparing(part -> {
            if (part instanceof MetaMachine) {
                MetaMachine partMachine = (MetaMachine)((Object)part);
                Block partBlock = partMachine.getBlockState().m_60734_();
                if (PartAbility.OUTPUT_ENERGY.isApplicable(partBlock)) {
                    return 1;
                }
                if (PartAbility.SUBSTATION_OUTPUT_ENERGY.isApplicable(partBlock)) {
                    return 2;
                }
                if (PartAbility.OUTPUT_LASER.isApplicable(partBlock)) {
                    return 3;
                }
            }
            return 4;
        })).toList();
    }

    @Override
    public void onStructureInvalid() {
        if (this.isWorkingEnabled() && this.recipeLogic.getStatus() == RecipeLogic.Status.WORKING && !ConfigHolder.INSTANCE.machines.harmlessActiveTransformers) {
            this.doExplosion(6.0f + (float)this.getTier());
        }
        super.onStructureInvalid();
        this.powerOutput = new EnergyContainerList(new ArrayList());
        this.powerInput = new EnergyContainerList(new ArrayList());
        this.getRecipeLogic().setStatus(RecipeLogic.Status.SUSPEND);
        this.converterSubscription.unsubscribe();
    }

    public static TraceabilityPredicate getHatchPredicates() {
        return Predicates.abilities(PartAbility.INPUT_ENERGY).setPreviewCount(1).or(Predicates.abilities(PartAbility.OUTPUT_ENERGY).setPreviewCount(2)).or(Predicates.abilities(PartAbility.SUBSTATION_INPUT_ENERGY).setPreviewCount(1)).or(Predicates.abilities(PartAbility.SUBSTATION_OUTPUT_ENERGY).setPreviewCount(1)).or(Predicates.abilities(PartAbility.INPUT_LASER).setPreviewCount(1)).or(Predicates.abilities(PartAbility.OUTPUT_LASER).setPreviewCount(1));
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        if (this.isFormed()) {
            if (!this.isWorkingEnabled()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.work_paused"));
            } else if (this.isActive()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.running"));
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.active_transformer.max_input", (Object[])new Object[]{FormattingUtil.formatNumbers(Math.abs(this.powerInput.getInputVoltage() * this.powerInput.getInputAmperage()))}));
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.active_transformer.max_output", (Object[])new Object[]{FormattingUtil.formatNumbers(Math.abs(this.powerOutput.getOutputVoltage() * this.powerOutput.getOutputAmperage()))}));
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.active_transformer.average_in", (Object[])new Object[]{FormattingUtil.formatNumbers(Math.abs(this.powerInput.getInputPerSec() / 20L))}));
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.active_transformer.average_out", (Object[])new Object[]{FormattingUtil.formatNumbers(Math.abs(this.powerOutput.getOutputPerSec() / 20L))}));
                if (!ConfigHolder.INSTANCE.machines.harmlessActiveTransformers) {
                    textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.active_transformer.danger_enabled"));
                }
            } else {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.idling"));
            }
        }
    }

    @Override
    @NotNull
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 190, 125);
        group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 182, 117).setBackground(this.getScreenTexture()).addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_())).addWidget((Widget)new ComponentPanelWidget(4, 17, this::addDisplayText).setMaxWidthLimit(150).clickHandler(this::handleDisplayClick)));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    @Override
    @NotNull
    public ModularUI createUI(@NotNull Player entityPlayer) {
        return new ModularUI(198, 208, (IUIHolder)this, entityPlayer).widget((Widget)new FancyMachineUIWidget(this, 198, 208));
    }
}

