/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.entity;

import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTEntityTypes;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.item.GTBoatItem;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class GTBoat
extends Boat {
    public GTBoat(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
        this.f_19850_ = true;
    }

    public GTBoat(Level level, double x, double y, double z) {
        super((EntityType)GTEntityTypes.BOAT.get(), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    @Nullable
    public Component m_7770_() {
        return super.m_7770_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("Type", this.getBoatType().getName());
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("Type")) {
            this.f_19804_.m_135381_(f_38285_, (Object)BoatType.byName(compound.m_128461_("Type")).ordinal());
        }
    }

    public Item m_38369_() {
        return switch (BoatType.byId((Integer)this.f_19804_.m_135370_(f_38285_))) {
            default -> throw new IncompatibleClassChangeError();
            case BoatType.RUBBER -> (GTBoatItem)((Object)GTItems.RUBBER_BOAT.get());
            case BoatType.TREATED_WOOD -> (GTBoatItem)((Object)GTItems.TREATED_WOOD_BOAT.get());
        };
    }

    public void setBoatType(BoatType type) {
        this.f_19804_.m_135381_(f_38285_, (Object)type.ordinal());
    }

    public BoatType getBoatType() {
        return BoatType.byId((Integer)this.f_19804_.m_135370_(f_38285_));
    }

    public void m_28464_(Boat.Type variant) {
    }

    public Boat.Type m_28554_() {
        return Boat.Type.OAK;
    }

    public static enum BoatType {
        RUBBER("rubber", (Block)GTBlocks.RUBBER_PLANK.get()),
        TREATED_WOOD("treated", (Block)GTBlocks.TREATED_WOOD_PLANK.get());

        private final String name;
        private final Block planks;
        private static final BoatType[] VALUES;

        private BoatType(String name, Block planks) {
            this.name = name;
            this.planks = planks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static BoatType byId(int id) {
            if (id < 0 || id >= VALUES.length) {
                id = 0;
            }
            return VALUES[id];
        }

        public static BoatType byName(String name) {
            return Arrays.stream(VALUES).filter(type -> type.getName().equals(name)).findFirst().orElse(VALUES[0]);
        }

        static {
            VALUES = BoatType.values();
        }
    }
}

