/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableTieredHullMachineRenderer;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MinerRenderer
extends WorkableTieredHullMachineRenderer {
    public static final ResourceLocation PIPE_IN_OVERLAY = GTCEu.id("block/overlay/machine/overlay_pipe_in");
    public static final ImmutableMap<Material, ResourceLocation> MATERIALS_TO_CASING_MODELS;

    public MinerRenderer(int tier, ResourceLocation modelLocation) {
        super(tier, modelLocation);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, @Nullable Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        if (side == Direction.DOWN) {
            quads.add(StaticFaceBakery.bakeFace(modelFacing, ModelFactory.getBlockSprite((ResourceLocation)PIPE_IN_OVERLAY), modelState));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            register.accept(PIPE_IN_OVERLAY);
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)GTMaterials.Bronze, (Object)GTCEu.id("block/casings/solid/machine_casing_bronze_plated_bricks"));
        builder.put((Object)GTMaterials.Invar, (Object)GTCEu.id("block/casings/solid/machine_casing_heatproof"));
        builder.put((Object)GTMaterials.Aluminium, (Object)GTCEu.id("block/casings/solid/machine_casing_frost_proof"));
        builder.put((Object)GTMaterials.Steel, (Object)GTCEu.id("block/casings/solid/machine_casing_solid_steel"));
        builder.put((Object)GTMaterials.StainlessSteel, (Object)GTCEu.id("block/casings/solid/machine_casing_clean_stainless_steel"));
        builder.put((Object)GTMaterials.Titanium, (Object)GTCEu.id("block/casings/solid/machine_casing_stable_titanium"));
        builder.put((Object)GTMaterials.TungstenSteel, (Object)GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel"));
        builder.put((Object)GTMaterials.Polytetrafluoroethylene, (Object)GTCEu.id("block/casings/solid/machine_casing_inert_ptfe"));
        builder.put((Object)GTMaterials.HSSE, (Object)GTCEu.id("block/casings/solid/machine_casing_sturdy_hsse"));
        MATERIALS_TO_CASING_MODELS = builder.build();
    }
}

