/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.client.renderer.machine.OverlayTieredMachineRenderer;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MaintenanceHatchPartRenderer
extends OverlayTieredMachineRenderer {
    private static final ResourceLocation MAINTENANCE_OVERLAY_TAPED = GTCEu.id("block/overlay/machine/overlay_maintenance_taped");

    public MaintenanceHatchPartRenderer(int tier, ResourceLocation overlayModel) {
        super(tier, overlayModel);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, @Nullable Direction modelFacing, ModelState modelState) {
        IMaintenanceMachine maintenanceHatch;
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        if (side == frontFacing && modelFacing != null && machine instanceof IMaintenanceMachine && (maintenanceHatch = (IMaintenanceMachine)((Object)machine)).isTaped()) {
            quads.add(StaticFaceBakery.bakeFace(StaticFaceBakery.SLIGHTLY_OVER_BLOCK, modelFacing, ModelFactory.getBlockSprite((ResourceLocation)MAINTENANCE_OVERLAY_TAPED), modelState, -1, 0, true, true));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            register.accept(MAINTENANCE_OVERLAY_TAPED);
        }
    }
}

