/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.renderer.GTRenderTypes;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.util.BloomUtils;
import com.gregtechceu.gtceu.client.util.RenderBufferHelper;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.FusionReactorMachine;
import com.lowdragmc.shimmer.client.shader.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FusionReactorRenderer
extends WorkableCasingMachineRenderer {
    public static final float FADEOUT = 60.0f;
    protected float delta = 0.0f;
    protected int lastColor = -1;

    public FusionReactorRenderer(ResourceLocation baseCasing, ResourceLocation workableModel) {
        super(baseCasing, workableModel);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        IMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof IMachineBlockEntity && (metaMachine = (machineBlockEntity = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof FusionReactorMachine) {
            FusionReactorMachine machine = (FusionReactorMachine)metaMachine;
            if (!machine.recipeLogic.isWorking() && this.delta <= 0.0f) {
                return;
            }
            if (GTCEu.Mods.isShimmerLoaded()) {
                PoseStack finalStack = RenderUtils.copyPoseStack((PoseStack)stack);
                BloomUtils.entityBloom(source -> this.renderLightRing(machine, partialTicks, finalStack, (MultiBufferSource)source));
            } else {
                this.renderLightRing(machine, partialTicks, stack, buffer);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderLightRing(FusionReactorMachine machine, float partialTicks, PoseStack stack, MultiBufferSource buffer) {
        Integer color = machine.getColor();
        float alpha = 1.0f;
        if (machine.recipeLogic.isWorking()) {
            this.lastColor = color;
            this.delta = 60.0f;
        } else {
            alpha = this.delta / 60.0f;
            this.lastColor = FastColor.ARGB32.m_13660_((int)Mth.m_14143_((float)(alpha * 255.0f)), (int)FastColor.ARGB32.m_13665_((int)this.lastColor), (int)FastColor.ARGB32.m_13667_((int)this.lastColor), (int)FastColor.ARGB32.m_13669_((int)this.lastColor));
            this.delta -= Minecraft.m_91087_().m_91297_();
        }
        float lerpFactor = Math.abs((float)Math.abs(machine.getOffsetTimer() % 50L) + partialTicks - 25.0f) / 25.0f;
        Direction front = machine.getFrontFacing();
        Direction upwards = machine.getUpwardsFacing();
        boolean flipped = machine.isFlipped();
        Direction back = RelativeDirection.BACK.getRelativeFacing(front, upwards, flipped);
        Direction.Axis axis = RelativeDirection.UP.getRelativeFacing(front, upwards, flipped).m_122434_();
        float r = Mth.m_14179_((float)lerpFactor, (float)FastColor.ARGB32.m_13665_((int)this.lastColor), (float)255.0f) / 255.0f;
        float g = Mth.m_14179_((float)lerpFactor, (float)FastColor.ARGB32.m_13667_((int)this.lastColor), (float)255.0f) / 255.0f;
        float b = Mth.m_14179_((float)lerpFactor, (float)FastColor.ARGB32.m_13669_((int)this.lastColor), (float)255.0f) / 255.0f;
        RenderBufferHelper.renderRing(stack, buffer.m_6299_(GTRenderTypes.getLightRing()), (float)(back.m_122429_() * 7) + 0.5f, (float)(back.m_122430_() * 7) + 0.5f, (float)(back.m_122431_() * 7) + 0.5f, 6.0f, 0.2f, 10, 20, r, g, b, alpha, axis);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getViewDistance() {
        return 32;
    }
}

