/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.block;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.client.model.SpriteOverrider;
import com.gregtechceu.gtceu.client.renderer.block.CTMModelRenderer;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextureOverrideRenderer
extends CTMModelRenderer {
    @NotNull
    protected Map<String, ResourceLocation> override;
    @Nullable
    protected Supplier<Map<String, ResourceLocation>> overrideSupplier;

    public TextureOverrideRenderer(ResourceLocation model, @NotNull Map<String, ResourceLocation> override) {
        super(model);
        this.override = override;
        if (GTCEu.isClientSide()) {
            this.registerEvent();
        }
    }

    public TextureOverrideRenderer(ResourceLocation model, @NotNull Supplier<Map<String, ResourceLocation>> overrideSupplier) {
        super(model);
        this.override = Collections.emptyMap();
        this.overrideSupplier = overrideSupplier;
        if (GTCEu.isClientSide()) {
            this.registerEvent();
        }
    }

    public TextureOverrideRenderer(ResourceLocation model) {
        super(model);
        this.override = Collections.emptyMap();
        if (GTCEu.isClientSide()) {
            this.registerEvent();
        }
    }

    public void setTextureOverride(Map<String, ResourceLocation> override) {
        this.override = override;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected BakedModel getItemBakedModel() {
        if (this.itemModel == null) {
            BlockModel blockModel;
            UnbakedModel model = this.getModel();
            if (model instanceof BlockModel && (blockModel = (BlockModel)model).m_111490_() == ModelBakery.f_119232_) {
                model = ModelFactory.ITEM_MODEL_GENERATOR.m_111670_((Function)new SpriteOverrider(this.override), blockModel);
            }
            this.itemModel = model.m_7611_(ModelFactory.getModeBaker(), (Function)new SpriteOverrider(this.override), (ModelState)BlockModelRotation.X0_Y0, this.modelLocation);
        }
        return this.itemModel;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BakedModel getRotatedModel(Direction frontFacing) {
        return this.blockModels.computeIfAbsent(frontFacing, facing -> this.getModel().m_7611_(ModelFactory.getModeBaker(), (Function)new SpriteOverrider(this.override), ModelFactory.getRotation((Direction)facing), this.modelLocation));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            if (this.overrideSupplier != null) {
                this.override = this.overrideSupplier.get();
            }
            for (ResourceLocation value : this.override.values()) {
                register.accept(value);
            }
        }
    }

    @NotNull
    @Generated
    public Map<String, ResourceLocation> getOverride() {
        return this.override;
    }

    @Nullable
    @Generated
    public Supplier<Map<String, ResourceLocation>> getOverrideSupplier() {
        return this.overrideSupplier;
    }
}

