/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client;

import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.particle.HazardParticleOptions;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.ClientLevelAccessor;
import it.unimi.dsi.fastutil.floats.FloatIntPair;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;

@OnlyIn(value=Dist.CLIENT)
public class EnvironmentalHazardClientHandler {
    public static final int PARTICLE_THRESHOLD = 200;
    public static final int MAX_PARTICLE_DISTANCE = 96;
    public static final int MAX_PARTICLE_DISTANCE_SQR = 9216;
    public static final float COLORING_LOW = 200.0f;
    public static final float COLORING_HIGH = 600.0f;
    public static final EnvironmentalHazardClientHandler INSTANCE = new EnvironmentalHazardClientHandler();
    private final Map<ChunkPos, EnvironmentalHazardSavedData.HazardZone> hazardZones = new ConcurrentHashMap<ChunkPos, EnvironmentalHazardSavedData.HazardZone>();
    private final Map<ChunkPos, FloatIntPair> chunkColorCache = new ConcurrentHashMap<ChunkPos, FloatIntPair>();

    private EnvironmentalHazardClientHandler() {
        if (ConfigHolder.INSTANCE.gameplay.hazardsEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void onClientTick() {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        RandomSource random = level.f_46441_;
        Vec3 playerPosition = Minecraft.m_91087_().f_91074_.m_146892_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (Map.Entry<ChunkPos, EnvironmentalHazardSavedData.HazardZone> entry : this.hazardZones.entrySet()) {
            BlockPos source;
            EnvironmentalHazardSavedData.HazardZone zone;
            ChunkPos chunkPos = entry.getKey();
            if (!level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_) || (zone = entry.getValue()).strength() < 200.0f || (source = chunkPos.m_151394_(zone.source().m_123342_())).m_203193_((Position)playerPosition) > 9216.0) continue;
            for (int i = 0; i < 32; ++i) {
                int randX = source.m_123341_() - random.m_188503_(9) + random.m_188503_(9);
                int randY = source.m_123342_() - random.m_188503_(9) + random.m_188503_(9);
                int randZ = source.m_123343_() - random.m_188503_(9) + random.m_188503_(9);
                pos.m_122178_(randX, randY, randZ);
                if (level.m_8055_((BlockPos)pos).m_60838_((BlockGetter)level, (BlockPos)pos)) continue;
                level.m_7106_((ParticleOptions)new HazardParticleOptions(zone.condition().color, zone.strength() / 250.0f), (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + random.m_188500_(), (double)pos.m_123343_() + random.m_188500_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void updateHazardMap(Map<ChunkPos, EnvironmentalHazardSavedData.HazardZone> newZones) {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        this.hazardZones.clear();
        this.hazardZones.putAll(newZones);
        for (Map.Entry<ChunkPos, EnvironmentalHazardSavedData.HazardZone> entry : newZones.entrySet()) {
            if (!(entry.getValue().strength() > 200.0f)) continue;
            ChunkPos pos = entry.getKey();
            for (int y = Minecraft.m_91087_().f_91073_.m_151560_(); y < Minecraft.m_91087_().f_91073_.m_151561_(); ++y) {
                Minecraft.m_91087_().f_91060_.m_109490_(pos.f_45578_, y, pos.f_45579_);
            }
            ((ClientLevelAccessor)Minecraft.m_91087_().f_91073_).getTintCaches().forEach((colorResolver, blockTintCache) -> blockTintCache.m_92655_(pos.f_45578_, pos.f_45579_));
        }
    }

    public void updateHazardStrength(ChunkPos pos, float newStrength) {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        if (this.hazardZones.containsKey(pos)) {
            this.hazardZones.get(pos).strength(newStrength);
        }
        if (newStrength > 200.0f) {
            this.updateChunks(pos);
        }
    }

    public void addHazardZone(ChunkPos pos, EnvironmentalHazardSavedData.HazardZone zone) {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        this.hazardZones.put(pos, zone);
        if (zone.strength() > 200.0f) {
            this.updateChunks(pos);
        }
    }

    public void removeHazardZone(ChunkPos pos) {
        this.hazardZones.remove(pos);
        this.updateChunks(pos);
    }

    private void updateChunks(ChunkPos pos) {
        for (int y = Minecraft.m_91087_().f_91073_.m_151560_(); y < Minecraft.m_91087_().f_91073_.m_151561_(); ++y) {
            Minecraft.m_91087_().f_91060_.m_109490_(pos.f_45578_, y, pos.f_45579_);
        }
        ((ClientLevelAccessor)Minecraft.m_91087_().f_91073_).getTintCaches().forEach((colorResolver, blockTintCache) -> blockTintCache.m_92655_(pos.f_45578_, pos.f_45579_));
    }

    public int colorZone(int color, ChunkPos pos) {
        EnvironmentalHazardSavedData.HazardZone zone = this.hazardZones.get(pos);
        if (zone == null) {
            return color;
        }
        FloatIntPair entry = this.chunkColorCache.get(pos);
        if (entry != null && (entry.firstFloat() > zone.strength() + 0.5f || entry.firstFloat() < zone.strength() - 0.5f)) {
            return entry.valueInt();
        }
        color = EnvironmentalHazardClientHandler.colorize(color, zone.strength(), zone.condition().color);
        this.chunkColorCache.put(pos, FloatIntPair.of((float)zone.strength(), (int)color));
        return color;
    }

    private static int colorize(int color, float pollution, int newColor) {
        if (pollution < 200.0f) {
            return color;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float ratio = (pollution - 200.0f) / 600.0f;
        if (ratio > 1.0f) {
            ratio = 1.0f;
        }
        float complement = 1.0f - ratio;
        r = (int)((float)r * complement + ratio * (float)FastColor.ARGB32.m_13665_((int)newColor)) & 0xFF;
        g = (int)((float)g * complement + ratio * (float)FastColor.ARGB32.m_13667_((int)newColor)) & 0xFF;
        b = (int)((float)b * complement + ratio * (float)FastColor.ARGB32.m_13669_((int)newColor)) & 0xFF;
        return FastColor.ARGB32.m_13660_((int)255, (int)r, (int)g, (int)b);
    }

    @Generated
    public Map<ChunkPos, EnvironmentalHazardSavedData.HazardZone> getHazardZones() {
        return this.hazardZones;
    }
}

