/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifierList;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.client.renderer.GTRendererProvider;
import com.gregtechceu.gtceu.client.renderer.machine.MachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.OverlaySteamMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.OverlayTieredMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.SimpleGeneratorMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableSidedCasingMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableSteamMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableTieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MachineBuilder<DEFINITION extends MachineDefinition>
extends BuilderBase<DEFINITION> {
    protected final Registrate registrate;
    protected final String name;
    protected final BiFunction<BlockBehaviour.Properties, DEFINITION, IMachineBlock> blockFactory;
    protected final BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory;
    protected final TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory;
    protected Function<ResourceLocation, DEFINITION> definition;
    protected Function<IMachineBlockEntity, MetaMachine> machine;
    @Nullable
    private Supplier<IRenderer> renderer;
    private VoxelShape shape = Shapes.m_83144_();
    private RotationState rotationState = RotationState.NON_Y_AXIS;
    private boolean hasTESR;
    private boolean renderMultiblockWorldPreview = true;
    private boolean renderMultiblockXEIPreview = true;
    private NonNullUnaryOperator<BlockBehaviour.Properties> blockProp = p -> p;
    private NonNullUnaryOperator<Item.Properties> itemProp = p -> p;
    private Consumer<BlockBuilder<? extends Block, ?>> blockBuilder;
    private Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder;
    private NonNullConsumer<BlockEntityType<BlockEntity>> onBlockEntityRegister = MetaMachineBlockEntity::onBlockEntityRegister;
    private GTRecipeType[] recipeTypes;
    private int tier;
    private Object2IntMap<RecipeCapability<?>> recipeOutputLimits = new Object2IntOpenHashMap();
    private int paintingColor;
    private BiFunction<ItemStack, Integer, Integer> itemColor;
    private PartAbility[] abilities;
    private final List<Component> tooltips;
    private BiConsumer<ItemStack, List<Component>> tooltipBuilder;
    private RecipeModifier recipeModifier;
    private boolean alwaysTryModifyRecipe;
    @NotNull
    private BiPredicate<IRecipeLogicMachine, GTRecipe> beforeWorking;
    @NotNull
    private Predicate<IRecipeLogicMachine> onWorking;
    @NotNull
    private Consumer<IRecipeLogicMachine> onWaiting;
    @NotNull
    private Consumer<IRecipeLogicMachine> afterWorking;
    private boolean regressWhenWaiting;
    private Supplier<BlockState> appearance;
    @Nullable
    private EditableMachineUI editableUI;
    private String langValue;

    protected MachineBuilder(Registrate registrate, String name, Function<ResourceLocation, DEFINITION> definition, Function<IMachineBlockEntity, MetaMachine> machine2, BiFunction<BlockBehaviour.Properties, DEFINITION, IMachineBlock> blockFactory, BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory, TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory) {
        super(new ResourceLocation(registrate.getModid(), name));
        this.paintingColor = Long.decode(ConfigHolder.INSTANCE.client.defaultPaintingColor).intValue();
        this.itemColor = (itemStack, tintIndex) -> tintIndex == 2 ? GTValues.VC[this.tier] : (tintIndex == 1 ? this.paintingColor : -1);
        this.abilities = new PartAbility[0];
        this.tooltips = new ArrayList<Component>();
        this.recipeModifier = new RecipeModifierList(GTRecipeModifiers.OC_NON_PERFECT);
        this.beforeWorking = (machine, recipe) -> true;
        this.onWorking = machine -> true;
        this.onWaiting = machine -> {};
        this.afterWorking = machine -> {};
        this.regressWhenWaiting = true;
        this.langValue = null;
        this.registrate = registrate;
        this.name = name;
        this.machine = machine2;
        this.blockFactory = blockFactory;
        this.itemFactory = itemFactory;
        this.blockEntityFactory = blockEntityFactory;
        this.definition = definition;
    }

    public MachineBuilder<DEFINITION> recipeType(GTRecipeType type) {
        this.recipeTypes = (GTRecipeType[])ArrayUtils.add((Object[])this.recipeTypes, (Object)type);
        return this;
    }

    public MachineBuilder<DEFINITION> recipeTypes(GTRecipeType ... types) {
        for (GTRecipeType type : types) {
            this.recipeTypes = (GTRecipeType[])ArrayUtils.add((Object[])this.recipeTypes, (Object)type);
        }
        return this;
    }

    public static <DEFINITION extends MachineDefinition> MachineBuilder<DEFINITION> create(Registrate registrate, String name, Function<ResourceLocation, DEFINITION> definitionFactory, Function<IMachineBlockEntity, MetaMachine> metaMachine, BiFunction<BlockBehaviour.Properties, DEFINITION, IMachineBlock> blockFactory, BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory, TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory) {
        return new MachineBuilder<DEFINITION>(registrate, name, definitionFactory, metaMachine, blockFactory, itemFactory, blockEntityFactory);
    }

    public MachineBuilder<DEFINITION> modelRenderer(Supplier<ResourceLocation> model) {
        this.renderer = () -> new MachineRenderer((ResourceLocation)model.get());
        return this;
    }

    public MachineBuilder<DEFINITION> defaultModelRenderer() {
        return this.modelRenderer(() -> new ResourceLocation(this.registrate.getModid(), "block/" + this.name));
    }

    public MachineBuilder<DEFINITION> tieredHullRenderer(ResourceLocation model) {
        return this.renderer(() -> new TieredHullMachineRenderer(this.tier, model));
    }

    public MachineBuilder<DEFINITION> overlayTieredHullRenderer(String name) {
        return this.renderer(() -> new OverlayTieredMachineRenderer(this.tier, new ResourceLocation(this.registrate.getModid(), "block/machine/part/" + name)));
    }

    public MachineBuilder<DEFINITION> overlaySteamHullRenderer(String name) {
        return this.renderer(() -> new OverlaySteamMachineRenderer(new ResourceLocation(this.registrate.getModid(), "block/machine/part/" + name)));
    }

    public MachineBuilder<DEFINITION> workableTieredHullRenderer(ResourceLocation workableModel) {
        return this.renderer(() -> new WorkableTieredHullMachineRenderer(this.tier, workableModel));
    }

    public MachineBuilder<DEFINITION> simpleGeneratorMachineRenderer(ResourceLocation workableModel) {
        return this.renderer(() -> new SimpleGeneratorMachineRenderer(this.tier, workableModel));
    }

    public MachineBuilder<DEFINITION> workableSteamHullRenderer(boolean isHighPressure, ResourceLocation workableModel) {
        return this.renderer(() -> new WorkableSteamMachineRenderer(isHighPressure, workableModel));
    }

    public MachineBuilder<DEFINITION> workableCasingRenderer(ResourceLocation baseCasing, ResourceLocation workableModel) {
        return this.renderer(() -> new WorkableCasingMachineRenderer(baseCasing, workableModel));
    }

    public MachineBuilder<DEFINITION> workableCasingRenderer(ResourceLocation baseCasing, ResourceLocation workableModel, boolean tint) {
        return this.renderer(() -> new WorkableCasingMachineRenderer(baseCasing, workableModel, tint));
    }

    public MachineBuilder<DEFINITION> sidedWorkableCasingRenderer(String basePath, ResourceLocation overlayModel, boolean tint) {
        return this.renderer(() -> new WorkableSidedCasingMachineRenderer(basePath, overlayModel, tint));
    }

    public MachineBuilder<DEFINITION> sidedWorkableCasingRenderer(String basePath, ResourceLocation overlayModel) {
        return this.renderer(() -> new WorkableSidedCasingMachineRenderer(basePath, overlayModel));
    }

    public MachineBuilder<DEFINITION> appearanceBlock(Supplier<? extends Block> block) {
        this.appearance = () -> ((Block)block.get()).m_49966_();
        return this;
    }

    public MachineBuilder<DEFINITION> tooltips(Component ... components) {
        this.tooltips.addAll(Arrays.stream(components).filter(Objects::nonNull).toList());
        return this;
    }

    public MachineBuilder<DEFINITION> conditionalTooltip(Component component, Supplier<Boolean> condition) {
        return this.conditionalTooltip(component, condition.get());
    }

    public MachineBuilder<DEFINITION> conditionalTooltip(Component component, boolean condition) {
        if (condition) {
            this.tooltips.add(component);
        }
        return this;
    }

    public MachineBuilder<DEFINITION> abilities(PartAbility ... abilities) {
        this.abilities = abilities;
        return this;
    }

    public MachineBuilder<DEFINITION> recipeModifier(RecipeModifier recipeModifier) {
        RecipeModifierList list;
        this.recipeModifier = recipeModifier instanceof RecipeModifierList ? (list = (RecipeModifierList)recipeModifier) : new RecipeModifierList(recipeModifier);
        return this;
    }

    public MachineBuilder<DEFINITION> recipeModifier(RecipeModifier recipeModifier, boolean alwaysTryModifyRecipe) {
        this.alwaysTryModifyRecipe = alwaysTryModifyRecipe;
        return this.recipeModifier(recipeModifier);
    }

    public MachineBuilder<DEFINITION> recipeModifiers(RecipeModifier ... recipeModifiers) {
        this.recipeModifier = new RecipeModifierList(recipeModifiers);
        return this;
    }

    public MachineBuilder<DEFINITION> recipeModifiers(boolean alwaysTryModifyRecipe, RecipeModifier ... recipeModifiers) {
        return this.recipeModifier(new RecipeModifierList(recipeModifiers), alwaysTryModifyRecipe);
    }

    public MachineBuilder<DEFINITION> noRecipeModifier() {
        this.recipeModifier = new RecipeModifierList(RecipeModifier.NO_MODIFIER);
        this.alwaysTryModifyRecipe = false;
        return this;
    }

    public MachineBuilder<DEFINITION> addOutputLimit(RecipeCapability<?> capability, int limit) {
        this.recipeOutputLimits.put(capability, limit);
        return this;
    }

    public MachineBuilder<DEFINITION> multiblockPreviewRenderer(boolean multiBlockWorldPreview, boolean multiBlockXEIPreview) {
        this.renderMultiblockWorldPreview = multiBlockWorldPreview;
        this.renderMultiblockXEIPreview = multiBlockXEIPreview;
        return this;
    }

    protected DEFINITION createDefinition() {
        return (DEFINITION)((MachineDefinition)this.definition.apply(new ResourceLocation(this.registrate.getModid(), this.name)));
    }

    @Override
    @HideFromJS
    public DEFINITION register() {
        DEFINITION definition = this.createDefinition();
        BlockBuilder<Block, Registrate> blockBuilder = BlockBuilderWrapper.makeBlockBuilder(this, definition);
        if (this.langValue != null) {
            blockBuilder.lang(this.langValue);
            ((MachineDefinition)definition).setLangValue(this.langValue);
        }
        if (this.blockBuilder != null) {
            this.blockBuilder.accept(blockBuilder);
        }
        BlockEntry block = blockBuilder.register();
        ItemBuilder<MetaMachineItem, Registrate> itemBuilder = ItemBuilderWrapper.makeItemBuilder(this, (BlockEntry<Block>)block);
        if (this.itemBuilder != null) {
            this.itemBuilder.accept(itemBuilder);
        }
        ItemEntry item = itemBuilder.register();
        BlockEntityBuilder blockEntityBuilder = ((BlockEntityBuilder)this.registrate.blockEntity(this.name, (type, pos, state) -> ((IMachineBlockEntity)this.blockEntityFactory.apply((Object)type, (Object)pos, (Object)state)).self()).onRegister(this.onBlockEntityRegister)).validBlock((NonNullSupplier)block);
        if (this.hasTESR) {
            blockEntityBuilder = blockEntityBuilder.renderer(() -> GTRendererProvider::getOrCreate);
        }
        BlockEntityEntry blockEntity = blockEntityBuilder.register();
        ((MachineDefinition)definition).setRecipeTypes(this.recipeTypes);
        ((MachineDefinition)definition).setBlockSupplier((Supplier<Block>)block);
        ((MachineDefinition)definition).setItemSupplier((Supplier<MetaMachineItem>)item);
        ((MachineDefinition)definition).setTier(this.tier);
        ((MachineDefinition)definition).setRecipeOutputLimits(this.recipeOutputLimits);
        ((MachineDefinition)definition).setBlockEntityTypeSupplier(() -> ((BlockEntityEntry)blockEntity).get());
        ((MachineDefinition)definition).setMachineSupplier(this.machine);
        ((MachineDefinition)definition).setTooltipBuilder((itemStack, components) -> {
            components.addAll(this.tooltips);
            if (this.tooltipBuilder != null) {
                this.tooltipBuilder.accept((ItemStack)itemStack, (List<Component>)components);
            }
        });
        ((MachineDefinition)definition).setRecipeModifier(this.recipeModifier);
        ((MachineDefinition)definition).setAlwaysTryModifyRecipe(this.alwaysTryModifyRecipe);
        ((MachineDefinition)definition).setBeforeWorking(this.beforeWorking);
        ((MachineDefinition)definition).setOnWorking(this.onWorking);
        ((MachineDefinition)definition).setOnWaiting(this.onWaiting);
        ((MachineDefinition)definition).setAfterWorking(this.afterWorking);
        ((MachineDefinition)definition).setRegressWhenWaiting(this.regressWhenWaiting);
        if (this.renderer == null) {
            this.renderer = () -> new MachineRenderer(new ResourceLocation(this.registrate.getModid(), "block/machine/" + this.name));
        }
        if (this.recipeTypes != null) {
            for (GTRecipeType type2 : this.recipeTypes) {
                if (type2 == null || type2.getIconSupplier() != null) continue;
                type2.setIconSupplier(() -> definition.asStack());
            }
        }
        if (this.appearance == null) {
            this.appearance = () -> ((BlockEntry)block).getDefaultState();
        }
        if (this.editableUI != null) {
            ((MachineDefinition)definition).setEditableUI(this.editableUI);
        }
        ((MachineDefinition)definition).setAppearance(this.appearance);
        ((MachineDefinition)definition).setRenderer(GTCEu.isClientSide() ? this.renderer.get() : IRenderer.EMPTY);
        ((MachineDefinition)definition).setShape(this.shape);
        ((MachineDefinition)definition).setDefaultPaintingColor(this.paintingColor);
        ((MachineDefinition)definition).setRenderXEIPreview(this.renderMultiblockXEIPreview);
        ((MachineDefinition)definition).setRenderWorldPreview(this.renderMultiblockWorldPreview);
        GTRegistries.MACHINES.register(((MachineDefinition)definition).getId(), definition);
        return definition;
    }

    @Generated
    public MachineBuilder<DEFINITION> definition(Function<ResourceLocation, DEFINITION> definition) {
        this.definition = definition;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> machine(Function<IMachineBlockEntity, MetaMachine> machine) {
        this.machine = machine;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> renderer(@Nullable Supplier<IRenderer> renderer) {
        this.renderer = renderer;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> shape(VoxelShape shape) {
        this.shape = shape;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> rotationState(RotationState rotationState) {
        this.rotationState = rotationState;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> hasTESR(boolean hasTESR) {
        this.hasTESR = hasTESR;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> renderMultiblockWorldPreview(boolean renderMultiblockWorldPreview) {
        this.renderMultiblockWorldPreview = renderMultiblockWorldPreview;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> renderMultiblockXEIPreview(boolean renderMultiblockXEIPreview) {
        this.renderMultiblockXEIPreview = renderMultiblockXEIPreview;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> blockProp(NonNullUnaryOperator<BlockBehaviour.Properties> blockProp) {
        this.blockProp = blockProp;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> itemProp(NonNullUnaryOperator<Item.Properties> itemProp) {
        this.itemProp = itemProp;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> blockBuilder(Consumer<BlockBuilder<? extends Block, ?>> blockBuilder) {
        this.blockBuilder = blockBuilder;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> itemBuilder(Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder) {
        this.itemBuilder = itemBuilder;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> onBlockEntityRegister(NonNullConsumer<BlockEntityType<BlockEntity>> onBlockEntityRegister) {
        this.onBlockEntityRegister = onBlockEntityRegister;
        return this;
    }

    @Generated
    public GTRecipeType[] recipeTypes() {
        return this.recipeTypes;
    }

    @Generated
    public int tier() {
        return this.tier;
    }

    @Generated
    public MachineBuilder<DEFINITION> tier(int tier) {
        this.tier = tier;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> recipeOutputLimits(Object2IntMap<RecipeCapability<?>> recipeOutputLimits) {
        this.recipeOutputLimits = recipeOutputLimits;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> paintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> itemColor(BiFunction<ItemStack, Integer, Integer> itemColor) {
        this.itemColor = itemColor;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> tooltipBuilder(BiConsumer<ItemStack, List<Component>> tooltipBuilder) {
        this.tooltipBuilder = tooltipBuilder;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> alwaysTryModifyRecipe(boolean alwaysTryModifyRecipe) {
        this.alwaysTryModifyRecipe = alwaysTryModifyRecipe;
        return this;
    }

    @NotNull
    @Generated
    public BiPredicate<IRecipeLogicMachine, GTRecipe> beforeWorking() {
        return this.beforeWorking;
    }

    @Generated
    public MachineBuilder<DEFINITION> beforeWorking(@NotNull BiPredicate<IRecipeLogicMachine, GTRecipe> beforeWorking) {
        if (beforeWorking == null) {
            throw new NullPointerException("beforeWorking is marked non-null but is null");
        }
        this.beforeWorking = beforeWorking;
        return this;
    }

    @NotNull
    @Generated
    public Predicate<IRecipeLogicMachine> onWorking() {
        return this.onWorking;
    }

    @Generated
    public MachineBuilder<DEFINITION> onWorking(@NotNull Predicate<IRecipeLogicMachine> onWorking) {
        if (onWorking == null) {
            throw new NullPointerException("onWorking is marked non-null but is null");
        }
        this.onWorking = onWorking;
        return this;
    }

    @NotNull
    @Generated
    public Consumer<IRecipeLogicMachine> onWaiting() {
        return this.onWaiting;
    }

    @Generated
    public MachineBuilder<DEFINITION> onWaiting(@NotNull Consumer<IRecipeLogicMachine> onWaiting) {
        if (onWaiting == null) {
            throw new NullPointerException("onWaiting is marked non-null but is null");
        }
        this.onWaiting = onWaiting;
        return this;
    }

    @NotNull
    @Generated
    public Consumer<IRecipeLogicMachine> afterWorking() {
        return this.afterWorking;
    }

    @Generated
    public MachineBuilder<DEFINITION> afterWorking(@NotNull Consumer<IRecipeLogicMachine> afterWorking) {
        if (afterWorking == null) {
            throw new NullPointerException("afterWorking is marked non-null but is null");
        }
        this.afterWorking = afterWorking;
        return this;
    }

    @Generated
    public boolean regressWhenWaiting() {
        return this.regressWhenWaiting;
    }

    @Generated
    public MachineBuilder<DEFINITION> regressWhenWaiting(boolean regressWhenWaiting) {
        this.regressWhenWaiting = regressWhenWaiting;
        return this;
    }

    @Generated
    public MachineBuilder<DEFINITION> appearance(Supplier<BlockState> appearance) {
        this.appearance = appearance;
        return this;
    }

    @Nullable
    @Generated
    public EditableMachineUI editableUI() {
        return this.editableUI;
    }

    @Generated
    public MachineBuilder<DEFINITION> editableUI(@Nullable EditableMachineUI editableUI) {
        this.editableUI = editableUI;
        return this;
    }

    @Generated
    public String langValue() {
        return this.langValue;
    }

    @Generated
    public MachineBuilder<DEFINITION> langValue(String langValue) {
        this.langValue = langValue;
        return this;
    }

    static class BlockBuilderWrapper {
        BlockBuilderWrapper() {
        }

        public static <DEFINITION extends MachineDefinition> BlockBuilder<Block, Registrate> makeBlockBuilder(MachineBuilder<DEFINITION> builder, DEFINITION definition) {
            return (BlockBuilder)builder.registrate.block(builder.name, properties -> {
                RotationState.set(builder.rotationState);
                MachineDefinition.setBuilt(definition);
                IMachineBlock b = builder.blockFactory.apply((BlockBehaviour.Properties)properties, definition);
                RotationState.clear();
                MachineDefinition.clearBuilt();
                return b.self();
            }).color(() -> () -> IMachineBlock::colorTinted).initialProperties(() -> Blocks.f_50061_).properties(BlockBehaviour.Properties::m_222994_).addLayer(() -> RenderType::m_110457_).blockstate(NonNullBiConsumer.noop()).properties(builder.blockProp).onRegister(b -> Arrays.stream(builder.abilities).forEach(a -> a.register(builder.tier, (Block)b)));
        }
    }

    static class ItemBuilderWrapper {
        ItemBuilderWrapper() {
        }

        public static <DEFINITION extends MachineDefinition> ItemBuilder<MetaMachineItem, Registrate> makeItemBuilder(MachineBuilder<DEFINITION> builder, BlockEntry<Block> block) {
            return ((ItemBuilder)builder.registrate.item(builder.name, properties -> builder.itemFactory.apply((IMachineBlock)block.get(), (Item.Properties)properties)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model(NonNullBiConsumer.noop()).color(() -> () -> builder.itemColor::apply).properties(builder.itemProp);
        }
    }
}

