/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.lookup;

import com.gregtechceu.gtceu.api.recipe.lookup.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapItemStackIngredient;
import com.gregtechceu.gtceu.core.mixins.IngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.IntersectionIngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.ItemValueAccessor;
import com.gregtechceu.gtceu.core.mixins.TagValueAccessor;
import com.gregtechceu.gtceu.utils.IngredientEquality;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;

public class MapIntersectionIngredient
extends AbstractMapIngredient {
    protected IntersectionIngredient intersectionIngredient;
    protected List<Ingredient> ingredients;

    public MapIntersectionIngredient(IntersectionIngredient ingredient) {
        this.intersectionIngredient = ingredient;
        this.ingredients = new ArrayList<Ingredient>(((IntersectionIngredientAccessor)ingredient).getChildren());
        this.ingredients.sort(IngredientEquality.INGREDIENT_COMPARATOR);
    }

    @Override
    protected int hash() {
        int hash = 31;
        for (Ingredient ingredient : this.ingredients) {
            for (Ingredient.Value value : ((IngredientAccessor)ingredient).getValues()) {
                if (value instanceof Ingredient.TagValue) {
                    Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                    hash *= 31 * ((TagValueAccessor)tagValue).getTag().f_203868_().hashCode();
                    continue;
                }
                hash *= 31 * ((ItemValueAccessor)value).getItem().m_41720_().hashCode();
            }
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            MapIntersectionIngredient other = (MapIntersectionIngredient)o;
            if (this.ingredients != null && other.ingredients != null) {
                if (this.ingredients.size() != other.ingredients.size()) {
                    return false;
                }
                for (int i = 0; i < this.ingredients.size(); ++i) {
                    Ingredient ingredient2;
                    Ingredient ingredient1 = this.ingredients.get(i);
                    if (IngredientEquality.ingredientEquals(ingredient1, ingredient2 = other.ingredients.get(i))) continue;
                    return false;
                }
                return true;
            }
        } else if (o instanceof MapItemStackIngredient) {
            MapItemStackIngredient stackIngredient = (MapItemStackIngredient)o;
            return this.intersectionIngredient.test(stackIngredient.stack);
        }
        return false;
    }

    public String toString() {
        return "MapIntersectionIngredient{ingredient=" + String.valueOf(this.intersectionIngredient) + "}";
    }
}

