/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntCircuitIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.NBTIngredient;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SizedIngredient
extends Ingredient {
    public static final ResourceLocation TYPE = GTCEu.id("sized");
    protected int amount;
    protected final Ingredient inner;
    protected ItemStack[] itemStacks = null;
    private boolean changed = true;
    public static final IIngredientSerializer<SizedIngredient> SERIALIZER = new IIngredientSerializer<SizedIngredient>(){

        @NotNull
        public SizedIngredient parse(FriendlyByteBuf buffer) {
            int amount = buffer.m_130242_();
            return new SizedIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), amount);
        }

        @NotNull
        public SizedIngredient parse(JsonObject json) {
            int amount = json.get("count").getAsInt();
            Ingredient inner = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            return new SizedIngredient(inner, amount);
        }

        public void write(FriendlyByteBuf buffer, SizedIngredient ingredient) {
            buffer.m_130130_(ingredient.getAmount());
            ingredient.inner.m_43923_(buffer);
        }
    };

    protected SizedIngredient(Ingredient inner, int amount) {
        super(Stream.empty());
        this.amount = amount;
        this.inner = inner;
    }

    protected SizedIngredient(@NotNull TagKey<Item> tag, int amount) {
        this(Ingredient.m_204132_(tag), amount);
    }

    protected SizedIngredient(ItemStack itemStack) {
        this(itemStack.m_41782_() || itemStack.m_41773_() > 0 ? NBTIngredient.createNBTIngredient(itemStack) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}), itemStack.m_41613_());
    }

    public static SizedIngredient create(ItemStack inner) {
        return new SizedIngredient(inner);
    }

    public static SizedIngredient create(Ingredient inner, int amount) {
        return new SizedIngredient(inner, amount);
    }

    public static SizedIngredient create(Ingredient inner) {
        return new SizedIngredient(inner, 1);
    }

    public static SizedIngredient create(TagKey<Item> tag, int amount) {
        return new SizedIngredient(tag, amount);
    }

    public static Ingredient copy(Ingredient ingredient) {
        if (ingredient instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)ingredient;
            Ingredient ingredient2 = sizedIngredient.inner;
            if (ingredient2 instanceof IntProviderIngredient) {
                IntProviderIngredient intProviderIngredient = (IntProviderIngredient)ingredient2;
                return SizedIngredient.copy(intProviderIngredient);
            }
            SizedIngredient copied = SizedIngredient.create(sizedIngredient.inner, sizedIngredient.amount);
            if (sizedIngredient.itemStacks != null) {
                copied.itemStacks = (ItemStack[])Arrays.stream(sizedIngredient.itemStacks).map(ItemStack::m_41777_).toArray(ItemStack[]::new);
            }
            return copied;
        }
        if (ingredient instanceof IntCircuitIngredient) {
            IntCircuitIngredient circuit = (IntCircuitIngredient)ingredient;
            return circuit.copy();
        }
        if (ingredient instanceof IntProviderIngredient) {
            IntProviderIngredient intProviderIngredient = (IntProviderIngredient)ingredient;
            IntProviderIngredient copied = new IntProviderIngredient(intProviderIngredient.inner, intProviderIngredient.countProvider);
            if (intProviderIngredient.itemStacks != null) {
                copied.itemStacks = (ItemStack[])Arrays.stream(intProviderIngredient.itemStacks).map(ItemStack::m_41777_).toArray(ItemStack[]::new);
            }
            if (intProviderIngredient.sampledCount != null) {
                copied.sampledCount = intProviderIngredient.sampledCount;
            }
            return copied;
        }
        return SizedIngredient.create(ingredient);
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public static SizedIngredient fromJson(JsonObject json) {
        return (SizedIngredient)SERIALIZER.parse(json);
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE.toString());
        json.addProperty("count", (Number)this.amount);
        json.add("ingredient", this.inner.m_43942_());
        return json;
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.inner.test(stack);
    }

    public ItemStack @NotNull [] m_43908_() {
        Ingredient ingredient = this.getInner();
        if (ingredient instanceof IntProviderIngredient) {
            IntProviderIngredient intProviderIngredient = (IntProviderIngredient)ingredient;
            return intProviderIngredient.m_43908_();
        }
        if (this.changed || this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.inner.m_43908_()).map(i -> {
                ItemStack ic = i.m_41777_();
                ic.m_41764_(this.amount);
                return ic;
            }).toArray(ItemStack[]::new);
            this.changed = false;
        }
        return this.itemStacks;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.changed = true;
    }

    @NotNull
    public IntList m_43931_() {
        return this.inner.m_43931_();
    }

    public boolean m_43947_() {
        return this.inner.m_43947_();
    }

    public int hashCode() {
        int result = this.amount;
        result = 31 * result + Arrays.hashCode(this.itemStacks);
        return result;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public Ingredient getInner() {
        return this.inner;
    }
}

