/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.VoidFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidContainerIngredient
extends Ingredient {
    public static final ResourceLocation TYPE = GTCEu.id("fluid_container");
    public static final Codec<FluidContainerIngredient> CODEC = FluidIngredient.CODEC.xmap(FluidContainerIngredient::new, FluidContainerIngredient::getFluid);
    private final FluidIngredient fluid;
    private ItemStack[] cachedStacks;
    public static final IIngredientSerializer<FluidContainerIngredient> SERIALIZER = new IIngredientSerializer<FluidContainerIngredient>(){

        @NotNull
        public FluidContainerIngredient parse(FriendlyByteBuf buffer) {
            FluidIngredient fluid = FluidIngredient.fromNetwork(buffer);
            return new FluidContainerIngredient(fluid);
        }

        @NotNull
        public FluidContainerIngredient parse(JsonObject json) {
            FluidIngredient fluid = FluidIngredient.fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"fluid"));
            return new FluidContainerIngredient(fluid);
        }

        public void write(FriendlyByteBuf buffer, FluidContainerIngredient ingredient) {
            ingredient.fluid.toNetwork(buffer);
        }
    };

    public FluidContainerIngredient(FluidIngredient fluid) {
        super(Stream.empty());
        this.fluid = fluid;
    }

    public FluidContainerIngredient(FluidStack fluidStack) {
        this(FluidIngredient.of(TagUtil.createFluidTag(BuiltInRegistries.f_257020_.m_7981_((Object)fluidStack.getFluid()).m_135815_()), fluidStack.getAmount()));
    }

    public FluidContainerIngredient(TagKey<Fluid> tag, int amount) {
        this(FluidIngredient.of(tag, amount, null));
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.cachedStacks == null) {
            this.cachedStacks = (ItemStack[])Arrays.stream(this.fluid.getStacks()).map(FluidUtil::getFilledBucket).filter(s -> !s.m_41619_()).toArray(ItemStack[]::new);
        }
        return this.cachedStacks;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE.toString());
        json.add("fluid", this.fluid.toJson());
        return json;
    }

    public boolean m_43947_() {
        return this.fluid.isEmpty();
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        return FluidUtil.getFluidContained((ItemStack)stack).map(this.fluid::test).orElse(false) != false && FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)VoidFluidHandler.INSTANCE, (int)this.fluid.getAmount(), null, (boolean)false).isSuccess();
    }

    public boolean isSimple() {
        return false;
    }

    public ItemStack getExtractedStack(ItemStack input) {
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)input, (IFluidHandler)VoidFluidHandler.INSTANCE, (int)this.fluid.getAmount(), (Player)ForgeHooks.getCraftingPlayer(), (boolean)true);
        if (result.isSuccess()) {
            return result.getResult();
        }
        return input;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public static FluidContainerIngredient fromJson(JsonObject json) {
        return (FluidContainerIngredient)SERIALIZER.parse(json);
    }

    @Generated
    public FluidIngredient getFluid() {
        return this.fluid;
    }
}

