/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.chance.logic;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.recipe.chance.boost.ChanceBoostFunction;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.ModLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ChanceLogic {
    public static final ChanceLogic OR;
    public static final ChanceLogic AND;
    public static final ChanceLogic XOR;
    public static final ChanceLogic NONE;

    public ChanceLogic(String id) {
        GTRegistries.CHANCE_LOGICS.register(id, this);
    }

    static int getChance(@NotNull Content entry, @NotNull ChanceBoostFunction boostFunction, int recipeTier, int chanceTier) {
        return boostFunction.getBoostedChance(entry, recipeTier, chanceTier);
    }

    static boolean passesChance(int chance, int maxChance) {
        return chance >= maxChance;
    }

    public static int getMaxChancedValue() {
        return 10000;
    }

    static int getCachedChance(Content entry, @Nullable Object2IntMap<?> cache) {
        if (cache == null || !cache.containsKey(entry.content)) {
            return GTValues.RNG.m_188503_(entry.maxChance);
        }
        return cache.getInt(entry.content);
    }

    static void updateCachedChance(Object ingredient, @Nullable Object2IntMap<?> cache, int chance) {
        if (cache == null) {
            return;
        }
        cache.put(ingredient, chance);
    }

    public abstract @Unmodifiable List<@NotNull Content> roll(@NotNull @NotNull @Unmodifiable List<@NotNull Content> var1, @NotNull ChanceBoostFunction var2, int var3, int var4, @Nullable Object2IntMap<?> var5, int var6);

    public @Unmodifiable List<@NotNull Content> roll(@NotNull @NotNull @Unmodifiable List<@NotNull Content> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int recipeTier, int chanceTier, int times) {
        return this.roll(chancedEntries, boostFunction, recipeTier, chanceTier, null, times);
    }

    @NotNull
    public abstract Component getTranslation();

    @ApiStatus.Internal
    public static void init() {
        ModLoader.get().postEvent(new GTCEuAPI.RegisterEvent(GTRegistries.CHANCE_LOGICS, ChanceLogic.class));
        GTRegistries.CHANCE_LOGICS.freeze();
    }

    static {
        GTRegistries.CHANCE_LOGICS.unfreeze();
        OR = new ChanceLogic("or"){

            @Override
            public @Unmodifiable List<@NotNull Content> roll(@NotNull @NotNull @Unmodifiable List<@NotNull Content> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int recipeTier, int chanceTier, @Nullable Object2IntMap<?> cache, int times) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Content entry : chancedEntries) {
                    int maxChance = entry.maxChance;
                    int newChance = 1.getChance(entry, boostFunction, recipeTier, chanceTier);
                    int totalChance = times * newChance;
                    int guaranteed = totalChance / maxChance;
                    if (guaranteed > 0) {
                        builder.addAll(Collections.nCopies(guaranteed, entry));
                    }
                    newChance = totalChance % maxChance;
                    int cached = 1.getCachedChance(entry, cache);
                    int chance = newChance + cached;
                    while (1.passesChance(chance, maxChance)) {
                        builder.add((Object)entry);
                        chance -= maxChance;
                        newChance -= maxChance;
                    }
                    1.updateCachedChance(entry.content, cache, newChance / 2 + cached);
                }
                return builder.build();
            }

            @Override
            @NotNull
            public Component getTranslation() {
                return Component.m_237115_((String)"gtceu.chance_logic.or");
            }

            public String toString() {
                return "ChanceLogic{OR}";
            }
        };
        AND = new ChanceLogic("and"){

            @Override
            public @Unmodifiable List<@NotNull Content> roll(@NotNull @NotNull @Unmodifiable List<@NotNull Content> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int recipeTier, int chanceTier, @Nullable Object2IntMap<?> cache, int times) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < times; ++i) {
                    boolean failed = false;
                    for (Content entry : chancedEntries) {
                        int cached;
                        int newChance = 2.getChance(entry, boostFunction, recipeTier, chanceTier);
                        int chance = newChance + (cached = 2.getCachedChance(entry, cache));
                        if (2.passesChance(chance, entry.maxChance)) {
                            newChance -= entry.maxChance;
                        } else {
                            failed = true;
                        }
                        2.updateCachedChance(entry.content, cache, newChance / 2 + cached);
                        if (!failed) continue;
                        break;
                    }
                    if (failed) continue;
                    builder.addAll(chancedEntries);
                }
                return builder.build();
            }

            @Override
            @NotNull
            public Component getTranslation() {
                return Component.m_237115_((String)"gtceu.chance_logic.and");
            }

            public String toString() {
                return "ChanceLogic{AND}";
            }
        };
        XOR = new ChanceLogic("xor"){

            @Override
            public @Unmodifiable List<@NotNull Content> roll(@NotNull @NotNull @Unmodifiable List<@NotNull Content> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int recipeTier, int chanceTier, @Nullable Object2IntMap<?> cache, int times) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < times; ++i) {
                    Content selected = null;
                    for (Content entry : chancedEntries) {
                        int cached;
                        int newChance = 3.getChance(entry, boostFunction, recipeTier, chanceTier);
                        int chance = newChance + (cached = 3.getCachedChance(entry, cache));
                        if (3.passesChance(chance, entry.maxChance)) {
                            selected = entry;
                            newChance -= entry.maxChance;
                        }
                        3.updateCachedChance(entry.content, cache, newChance / 2 + cached);
                        if (selected == null) continue;
                        break;
                    }
                    if (selected == null) continue;
                    builder.add(selected);
                }
                return builder.build();
            }

            @Override
            @NotNull
            public Component getTranslation() {
                return Component.m_237115_((String)"gtceu.chance_logic.xor");
            }

            public String toString() {
                return "ChanceLogic{XOR}";
            }
        };
        NONE = new ChanceLogic("none"){

            @Override
            public @Unmodifiable List<@NotNull Content> roll(@NotNull @NotNull @Unmodifiable List<@NotNull Content> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int recipeTier, int chanceTier, @Nullable Object2IntMap<?> cache, int times) {
                return Collections.emptyList();
            }

            @Override
            @NotNull
            public Component getTranslation() {
                return Component.m_237115_((String)"gtceu.chance_logic.none");
            }

            public String toString() {
                return "ChanceLogic{NONE}";
            }
        };
    }
}

