/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.core.mixins.ShapedRecipeAccessor;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StrictShapedRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<StrictShapedRecipe> SERIALIZER = new Serializer();

    public StrictShapedRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        super(id, group, category, width, height, recipeItems, result);
    }

    public boolean m_5818_(CraftingContainer inv, Level level) {
        for (int i = 0; i <= inv.m_39347_() - this.m_44220_(); ++i) {
            for (int j = 0; j <= inv.m_39346_() - this.m_44221_(); ++j) {
                if (!this.matches(inv, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingContainer craftingInventory, int width, int height) {
        for (int i = 0; i < craftingInventory.m_39347_(); ++i) {
            for (int j = 0; j < craftingInventory.m_39346_(); ++j) {
                int k = i - width;
                int l = j - height;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.m_44220_() && l < this.m_44221_()) {
                    ingredient = (Ingredient)this.m_7527_().get(k + l * this.m_44220_());
                }
                if (ingredient.test(craftingInventory.m_8020_(i + j * craftingInventory.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<StrictShapedRecipe> {
        public StrictShapedRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String string = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Map<String, Ingredient> map = ShapedRecipeAccessor.callKeyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] strings = ShapedRecipeAccessor.callPatternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern"));
            int i = strings[0].length();
            int j = strings.length;
            NonNullList<Ingredient> nonNullList = ShapedRecipeAccessor.callDissolvePattern(strings, map, i, j);
            ItemStack itemStack = StrictShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new StrictShapedRecipe(recipeId, string, craftingBookCategory, i, j, nonNullList, itemStack);
        }

        public StrictShapedRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            int j = buffer.m_130242_();
            String string = buffer.m_130277_();
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            NonNullList nonNullList = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            nonNullList.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack itemStack = buffer.m_130267_();
            return new StrictShapedRecipe(recipeId, string, craftingBookCategory, i, j, (NonNullList<Ingredient>)nonNullList, itemStack);
        }

        public void toNetwork(FriendlyByteBuf buffer, StrictShapedRecipe recipe) {
            buffer.m_130130_(recipe.m_44220_());
            buffer.m_130130_(recipe.m_44221_());
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(((ShapedRecipeAccessor)((Object)recipe)).getResult());
        }
    }
}

