/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.common.collect.Table;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.chance.boost.ChanceBoostFunction;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

class RecipeRunner {
    private final GTRecipe recipe;
    private final IO io;
    private final boolean isTick;
    private final IRecipeCapabilityHolder holder;
    private final Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches;
    private final Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilityProxies;
    private final boolean simulated;
    private RecipeCapability<?> capability;
    private Set<IRecipeHandler<?>> used;
    private ContentSlots content;
    private ContentSlots search;

    public RecipeRunner(GTRecipe recipe, IO io, boolean isTick, IRecipeCapabilityHolder holder, Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches, boolean simulated) {
        this.recipe = recipe;
        this.io = io;
        this.isTick = isTick;
        this.holder = holder;
        this.chanceCaches = chanceCaches;
        this.capabilityProxies = holder.getCapabilitiesProxy();
        this.simulated = simulated;
    }

    @Nullable
    public RecipeHandlingResult handle(Map.Entry<RecipeCapability<?>, List<Content>> entry) {
        this.initState();
        this.fillContent(this.holder, entry);
        this.capability = this.resolveCapability(entry);
        if (this.capability == null) {
            return null;
        }
        ContentSlots result = this.handleContents();
        if (result == null) {
            return null;
        }
        return new RecipeHandlingResult(this.capability, result);
    }

    private void initState() {
        this.used = new HashSet();
        this.content = new ContentSlots();
        this.search = this.simulated ? this.content : new ContentSlots();
    }

    private void fillContent(IRecipeCapabilityHolder holder, Map.Entry<RecipeCapability<?>, List<Content>> entry) {
        RecipeCapability<?> cap = entry.getKey();
        ChanceBoostFunction function = this.recipe.getType().getChanceFunction();
        ChanceLogic logic = this.recipe.getChanceLogicForCapability(cap, this.io, this.isTick);
        List<Content> chancedContents = new ArrayList<Content>();
        for (Content cont : entry.getValue()) {
            if (cont.slotName == null) {
                this.search.content.add(cont.content);
            } else {
                this.search.slots.computeIfAbsent(cont.slotName, s -> new ArrayList()).add(cont.content);
            }
            if (this.simulated) continue;
            if (cont.chance >= cont.maxChance) {
                if (cont.slotName == null) {
                    this.content.content.add(cont.content);
                    continue;
                }
                this.content.slots.computeIfAbsent(cont.slotName, s -> new ArrayList()).add(cont.content);
                continue;
            }
            chancedContents.add(cont);
        }
        if (!chancedContents.isEmpty()) {
            int recipeTier = RecipeHelper.getPreOCRecipeEuTier(this.recipe);
            int chanceTier = recipeTier + this.recipe.ocLevel;
            Object2IntMap<?> cache = this.chanceCaches.get(cap);
            chancedContents = logic.roll(chancedContents, function, recipeTier, chanceTier, cache, this.recipe.parallels);
            for (Content cont : chancedContents) {
                if (cont.slotName == null) {
                    this.content.content.add(cont.content);
                    continue;
                }
                this.content.slots.computeIfAbsent(cont.slotName, s -> new ArrayList()).add(cont.content);
            }
        }
    }

    private RecipeCapability<?> resolveCapability(Map.Entry<RecipeCapability<?>, List<Content>> entry) {
        RecipeCapability<?> capability = entry.getKey();
        if (!capability.doMatchInRecipe()) {
            return null;
        }
        this.content.content = this.content.content.stream().map(capability::copyContent).toList();
        if (this.content.content.isEmpty() && this.content.slots.isEmpty()) {
            return null;
        }
        if (this.content.content.isEmpty()) {
            this.content.content = null;
        }
        return capability;
    }

    @Nullable
    private ContentSlots handleContents() {
        this.handleContentsInternal(this.io);
        if (this.content.content == null && this.content.slots.isEmpty()) {
            return null;
        }
        this.handleContentsInternal(IO.BOTH);
        return this.content;
    }

    private void handleContentsInternal(IO capIO) {
        if (!this.capabilityProxies.contains((Object)capIO, this.capability)) {
            return;
        }
        ArrayList handlers = new ArrayList((Collection)this.capabilityProxies.get((Object)capIO, this.capability));
        handlers.sort(IRecipeHandler.ENTRY_COMPARATOR);
        for (IRecipeHandler iRecipeHandler : handlers) {
            if (!iRecipeHandler.isDistinct()) continue;
            List result = iRecipeHandler.handleRecipe(this.io, this.recipe, this.search.content, null, true);
            if (result == null) {
                if (iRecipeHandler.getSlotNames() != null && iRecipeHandler.getSlotNames().containsAll(this.search.slots.keySet())) {
                    boolean success = true;
                    for (Map.Entry<String, List> entry : this.search.slots.entrySet()) {
                        List left = iRecipeHandler.handleRecipe(this.io, this.recipe, entry.getValue(), entry.getKey(), true);
                        if (left == null) continue;
                        success = false;
                        break;
                    }
                    if (success) {
                        if (!this.simulated) {
                            for (Map.Entry<String, List> entry : this.content.slots.entrySet()) {
                                iRecipeHandler.handleRecipe(this.io, this.recipe, entry.getValue(), entry.getKey(), false);
                            }
                        }
                        this.content.slots.clear();
                    }
                }
                if (this.content.slots.isEmpty()) {
                    if (!this.simulated) {
                        iRecipeHandler.handleRecipe(this.io, this.recipe, this.content.content, null, false);
                    }
                    this.content.content = null;
                }
            }
            if (this.content.content != null || !this.content.slots.isEmpty()) continue;
            break;
        }
        if (this.content.content != null || !this.content.slots.isEmpty()) {
            for (IRecipeHandler iRecipeHandler : handlers) {
                if (this.used.contains(iRecipeHandler) || iRecipeHandler.isDistinct()) continue;
                this.used.add(iRecipeHandler);
                if (this.content.content != null) {
                    this.content.content = iRecipeHandler.handleRecipe(this.io, this.recipe, this.content.content, null, this.simulated);
                }
                if (iRecipeHandler.getSlotNames() != null) {
                    Iterator<String> iterator = this.content.slots.keySet().iterator();
                    while (iterator.hasNext()) {
                        List left;
                        String key = iterator.next();
                        if (!iRecipeHandler.getSlotNames().contains(key) || (left = iRecipeHandler.handleRecipe(this.io, this.recipe, this.content.slots.get(key), key, this.simulated)) != null) continue;
                        iterator.remove();
                    }
                }
                if (this.content.content != null || !this.content.slots.isEmpty()) continue;
                break;
            }
        }
    }

    static class ContentSlots {
        public @UnknownNullability List content = new ArrayList();
        @NotNull
        public Map<String, List> slots = new HashMap<String, List>();

        ContentSlots() {
        }
    }

    record RecipeHandlingResult(RecipeCapability<?> capability, ContentSlots result) {
    }
}

