/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class ItemHandlerProxyRecipeTrait
extends NotifiableRecipeHandlerTrait<Ingredient>
implements ICapabilityTrait {
    public final IO handlerIO;
    public final IO capabilityIO;
    private long timeStamp = Long.MIN_VALUE;
    private boolean enabled;
    private final Collection<NotifiableRecipeHandlerTrait<Ingredient>> handlers;

    public ItemHandlerProxyRecipeTrait(MetaMachine machine, Collection<NotifiableRecipeHandlerTrait<Ingredient>> handlers, IO handlerIO, IO capabilityIO) {
        super(machine);
        this.handlerIO = handlerIO;
        this.capabilityIO = capabilityIO;
        this.handlers = handlers;
    }

    @Override
    public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, @Nullable String slotName, boolean simulate) {
        if (!this.enabled) {
            return left;
        }
        for (IRecipeHandler iRecipeHandler : this.handlers) {
            iRecipeHandler.handleRecipeInner(io, recipe, left, slotName, simulate);
            if (!left.isEmpty()) continue;
            return null;
        }
        return left;
    }

    @Override
    public List<Object> getContents() {
        ObjectArrayList contents = new ObjectArrayList(2);
        for (NotifiableRecipeHandlerTrait<Ingredient> handler : this.handlers) {
            contents.addAll(handler.getContents());
        }
        return contents;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (NotifiableRecipeHandlerTrait<Ingredient> handlerTrait : this.handlers) {
            size += handlerTrait.getSize();
        }
        return size;
    }

    @Override
    public double getTotalContentAmount() {
        long amount = 0L;
        for (NotifiableRecipeHandlerTrait<Ingredient> handlerTrait : this.handlers) {
            amount = (long)((double)amount + handlerTrait.getTotalContentAmount());
        }
        return amount;
    }

    @Override
    public RecipeCapability<Ingredient> getCapability() {
        return ItemRecipeCapability.CAP;
    }

    @Override
    public boolean isDistinct() {
        for (NotifiableRecipeHandlerTrait<Ingredient> handler : this.handlers) {
            if (handler.isDistinct) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.handlers.forEach(handler -> handler.setDistinct(distinct));
        this.recomputeEnabledState();
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    public void recomputeEnabledState() {
        this.enabled = this.isDistinct();
    }

    @Override
    @Generated
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    @Generated
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }

    @Generated
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Generated
    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Generated
    public Collection<NotifiableRecipeHandlerTrait<Ingredient>> getHandlers() {
        return this.handlers;
    }
}

