/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidTankProxyTrait
extends MachineTrait
implements IFluidHandlerModifiable,
ICapabilityTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FluidTankProxyTrait.class);
    public final IO capabilityIO;
    public IFluidHandlerModifiable proxy;

    public FluidTankProxyTrait(MetaMachine machine, IO capabilityIO) {
        super(machine);
        this.capabilityIO = capabilityIO;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public int getTanks() {
        return this.proxy == null ? 0 : this.proxy.getTanks();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.proxy == null ? FluidStack.EMPTY : this.proxy.getFluidInTank(tank);
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        if (this.proxy != null) {
            this.proxy.setFluidInTank(tank, fluidStack);
        }
    }

    public int getTankCapacity(int tank) {
        return this.proxy == null ? 0 : this.proxy.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.proxy != null && this.proxy.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.proxy != null && this.canCapInput()) {
            return this.proxy.fill(resource, action);
        }
        return 0;
    }

    public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.proxy != null && !resource.isEmpty()) {
            return this.proxy.fill(resource, action);
        }
        return 0;
    }

    public FluidStack drainInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.proxy != null && !resource.isEmpty()) {
            return this.proxy.drain(resource, action);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.proxy != null && this.canCapOutput()) {
            return this.proxy.drain(maxDrain, action);
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.proxy != null && this.canCapOutput()) {
            return this.proxy.drain(resource, action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drainInternal(int maxDrain, IFluidHandler.FluidAction action) {
        return this.proxy == null ? FluidStack.EMPTY : this.proxy.drain(maxDrain, action);
    }

    public boolean isEmpty() {
        IFluidHandlerModifiable iFluidHandlerModifiable = this.proxy;
        if (iFluidHandlerModifiable instanceof NotifiableFluidTank) {
            NotifiableFluidTank fluidTank = (NotifiableFluidTank)iFluidHandlerModifiable;
            return fluidTank.isEmpty();
        }
        boolean isEmpty = true;
        if (this.proxy != null) {
            for (int i = 0; i < this.proxy.getTanks(); ++i) {
                if (this.proxy.getFluidInTank(i).isEmpty()) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public void exportToNearby(Direction ... facings) {
        if (this.isEmpty()) {
            return;
        }
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            Predicate<FluidStack> filter = this.getMachine().getFluidCapFilter(facing, IO.OUT);
            GTTransferUtils.getAdjacentFluidHandler(level, pos, facing).ifPresent(adj -> GTTransferUtils.transferFluidsFiltered(this, adj, filter));
        }
    }

    @Override
    @Generated
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }

    @Generated
    public FluidTankProxyTrait setProxy(IFluidHandlerModifiable proxy) {
        this.proxy = proxy;
        return this;
    }

    @Generated
    public IFluidHandlerModifiable getProxy() {
        return this.proxy;
    }
}

