/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class FluidHandlerProxyRecipeTrait
extends NotifiableRecipeHandlerTrait<FluidIngredient>
implements ICapabilityTrait {
    public final IO handlerIO;
    public final IO capabilityIO;
    private long timeStamp = Long.MIN_VALUE;
    private boolean enabled;
    private final Collection<NotifiableRecipeHandlerTrait<FluidIngredient>> handlers;

    public FluidHandlerProxyRecipeTrait(MetaMachine machine, Collection<NotifiableRecipeHandlerTrait<FluidIngredient>> handlers, IO handlerIO, IO capabilityIO) {
        super(machine);
        this.handlerIO = handlerIO;
        this.capabilityIO = capabilityIO;
        this.handlers = handlers;
    }

    @Override
    public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, @Nullable String slotName, boolean simulate) {
        if (!this.enabled) {
            return left;
        }
        for (IRecipeHandler iRecipeHandler : this.handlers) {
            iRecipeHandler.handleRecipeInner(io, recipe, left, slotName, simulate);
            if (!left.isEmpty()) continue;
            return null;
        }
        return left;
    }

    @Override
    public List<Object> getContents() {
        ObjectArrayList contents = new ObjectArrayList(2);
        for (NotifiableRecipeHandlerTrait<FluidIngredient> handler : this.handlers) {
            contents.addAll(handler.getContents());
        }
        return contents;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (NotifiableRecipeHandlerTrait<FluidIngredient> handlerTrait : this.handlers) {
            size += handlerTrait.getSize();
        }
        return size;
    }

    @Override
    public double getTotalContentAmount() {
        long amount = 0L;
        for (NotifiableRecipeHandlerTrait<FluidIngredient> handlerTrait : this.handlers) {
            amount = (long)((double)amount + handlerTrait.getTotalContentAmount());
        }
        return amount;
    }

    @Override
    public RecipeCapability<FluidIngredient> getCapability() {
        return FluidRecipeCapability.CAP;
    }

    @Override
    public boolean isDistinct() {
        for (NotifiableRecipeHandlerTrait<FluidIngredient> handler : this.handlers) {
            if (handler.isDistinct) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.handlers.forEach(handler -> handler.setDistinct(distinct));
        this.recomputeEnabledState();
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    public void recomputeEnabledState() {
        this.enabled = this.isDistinct();
    }

    @Override
    @Generated
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    @Generated
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }

    @Generated
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Generated
    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Generated
    public Collection<NotifiableRecipeHandlerTrait<FluidIngredient>> getHandlers() {
        return this.handlers;
    }
}

