/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.BlockProperties;
import com.gregtechceu.gtceu.api.block.IAppearance;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.IPaintable;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IToolable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighlight;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineCoverContainer;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRedstoneSignalMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.misc.IOFilteredInvWrapper;
import com.gregtechceu.gtceu.api.misc.IOFluidHandlerList;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.common.cover.FluidFilterCover;
import com.gregtechceu.gtceu.common.cover.ItemFilterCover;
import com.gregtechceu.gtceu.common.item.tool.behavior.ToolModeSwitchBehavior;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.IManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.DummyWorld;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MetaMachine
implements IEnhancedManaged,
IToolable,
ITickSubscription,
IAppearance,
IToolGridHighlight,
IFancyTooltip,
IPaintable,
IRedstoneSignalMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MetaMachine.class);
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
    public final IMachineBlockEntity holder;
    @DescSynced
    @Persisted(key="cover")
    protected final MachineCoverContainer coverContainer;
    @Persisted
    @DescSynced
    @RequireRerender
    private int paintingColor = -1;
    protected final List<MachineTrait> traits;
    private final List<TickableSubscription> serverTicks;
    private final List<TickableSubscription> waitingToAdd;
    public boolean isFirstDummyWorldTick = true;

    public MetaMachine(IMachineBlockEntity holder) {
        this.holder = holder;
        this.coverContainer = new MachineCoverContainer(this);
        this.traits = new ArrayList<MachineTrait>();
        this.serverTicks = new ArrayList<TickableSubscription>();
        this.waitingToAdd = new ArrayList<TickableSubscription>();
        if (holder.getRootStorage() != null) {
            this.holder.getRootStorage().attach((IManagedStorage)this.getSyncStorage());
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        Level level = this.getLevel();
        if (level != null && !level.f_46443_ && level.m_7654_() != null) {
            level.m_7654_().execute(this::markDirty);
        }
    }

    @Nullable
    public Level getLevel() {
        return this.holder.level();
    }

    public BlockPos getPos() {
        return this.holder.pos();
    }

    public BlockState getBlockState() {
        return this.holder.getSelf().m_58900_();
    }

    public boolean isRemote() {
        return this.getLevel() == null ? GTCEu.isClientThread() : this.getLevel().f_46443_;
    }

    public void notifyBlockUpdate() {
        this.holder.notifyBlockUpdate();
    }

    public void scheduleRenderUpdate() {
        this.holder.scheduleRenderUpdate();
    }

    public void scheduleNeighborShapeUpdate() {
        Level level = this.getLevel();
        BlockPos pos = this.getPos();
        if (level == null || pos == null) {
            return;
        }
        level.m_8055_(pos).m_60701_((LevelAccessor)level, pos, 3);
    }

    public long getOffsetTimer() {
        return this.holder.getOffsetTimer();
    }

    public void markDirty() {
        this.holder.getSelf().m_6596_();
    }

    public boolean isInValid() {
        return this.holder.getSelf().m_58901_();
    }

    public void onUnload() {
        this.traits.forEach(MachineTrait::onMachineUnLoad);
        this.coverContainer.onUnload();
        for (TickableSubscription serverTick : this.serverTicks) {
            serverTick.unsubscribe();
        }
        this.serverTicks.clear();
    }

    public void onLoad() {
        this.traits.forEach(MachineTrait::onMachineLoad);
        this.coverContainer.onLoad();
    }

    public void saveCustomPersistedData(@NotNull CompoundTag tag, boolean forDrop) {
        for (MachineTrait trait : this.getTraits()) {
            trait.saveCustomPersistedData(tag, forDrop);
        }
    }

    public void loadCustomPersistedData(@NotNull CompoundTag tag) {
        for (MachineTrait trait : this.getTraits()) {
            trait.loadCustomPersistedData(tag);
        }
    }

    @Override
    @Nullable
    public TickableSubscription subscribeServerTick(Runnable runnable) {
        if (!this.isRemote()) {
            Level level;
            TickableSubscription subscription = new TickableSubscription(runnable);
            this.waitingToAdd.add(subscription);
            BlockState blockState = this.getBlockState();
            if (!((Boolean)blockState.m_61143_((Property)BlockProperties.SERVER_TICK)).booleanValue() && (level = this.getLevel()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                blockState = (BlockState)blockState.m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(true));
                this.holder.getSelf().m_155250_(blockState);
                serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, () -> {
                    if (!this.isInValid()) {
                        serverLevel.m_46597_(this.getPos(), (BlockState)this.getBlockState().m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(true)));
                    }
                }));
            }
            return subscription;
        }
        if (this.getLevel() instanceof DummyWorld) {
            TickableSubscription subscription = new TickableSubscription(runnable);
            this.waitingToAdd.add(subscription);
            return subscription;
        }
        return null;
    }

    @Override
    public void unsubscribe(@Nullable TickableSubscription current) {
        if (current != null) {
            current.unsubscribe();
        }
    }

    public final void serverTick() {
        this.executeTick();
        if (this.serverTicks.isEmpty() && this.waitingToAdd.isEmpty() && !this.isInValid()) {
            this.getLevel().m_46597_(this.getPos(), (BlockState)this.getBlockState().m_61124_((Property)BlockProperties.SERVER_TICK, (Comparable)Boolean.valueOf(false)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        if (this.getLevel() instanceof DummyWorld) {
            if (this.isFirstDummyWorldTick) {
                this.isFirstDummyWorldTick = false;
                this.onLoad();
            }
            this.executeTick();
        }
    }

    private void executeTick() {
        if (!this.waitingToAdd.isEmpty()) {
            this.serverTicks.addAll(this.waitingToAdd);
            this.waitingToAdd.clear();
        }
        Iterator<TickableSubscription> iter = this.serverTicks.iterator();
        while (iter.hasNext()) {
            TickableSubscription tickable = iter.next();
            if (tickable.isStillSubscribed()) {
                tickable.run();
            }
            if (this.isInValid()) break;
            if (tickable.isStillSubscribed()) continue;
            iter.remove();
        }
    }

    @Override
    public final Pair<GTToolType, InteractionResult> onToolClick(Set<@NotNull GTToolType> toolType, ItemStack itemStack, UseOnContext context) {
        CoverBehavior coverBehavior;
        Player playerIn = context.m_43723_();
        if (playerIn == null) {
            return Pair.of(null, (Object)InteractionResult.PASS);
        }
        InteractionHand hand = context.m_43724_();
        BlockHitResult hitResult = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), false);
        Direction gridSide = ICoverable.determineGridSideHit(hitResult);
        CoverBehavior coverBehavior2 = coverBehavior = gridSide == null ? null : this.coverContainer.getCoverAtSide(gridSide);
        if (gridSide == null) {
            gridSide = hitResult.m_82434_();
        }
        if (toolType.isEmpty() && playerIn.m_6144_() && coverBehavior != null) {
            return Pair.of(null, (Object)coverBehavior.onScrewdriverClick(playerIn, hand, hitResult));
        }
        if (toolType.contains(GTToolType.SCREWDRIVER)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SCREWDRIVER, (Object)coverBehavior.onScrewdriverClick(playerIn, hand, hitResult));
            }
            return Pair.of((Object)GTToolType.SCREWDRIVER, (Object)this.onScrewdriverClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.SOFT_MALLET)) {
            if (coverBehavior != null) {
                return Pair.of((Object)GTToolType.SOFT_MALLET, (Object)coverBehavior.onSoftMalletClick(playerIn, hand, hitResult));
            }
            return Pair.of((Object)GTToolType.SOFT_MALLET, (Object)this.onSoftMalletClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.WRENCH)) {
            return Pair.of((Object)GTToolType.WRENCH, (Object)this.onWrenchClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.CROWBAR)) {
            if (coverBehavior != null) {
                if (!this.isRemote()) {
                    this.getCoverContainer().removeCover(gridSide, playerIn);
                }
                return Pair.of((Object)GTToolType.CROWBAR, (Object)InteractionResult.CONSUME);
            }
            return Pair.of((Object)GTToolType.CROWBAR, (Object)this.onCrowbarClick(playerIn, hand, gridSide, hitResult));
        }
        if (toolType.contains(GTToolType.HARD_HAMMER)) {
            return Pair.of((Object)GTToolType.HARD_HAMMER, (Object)this.onHardHammerClick(playerIn, hand, gridSide, hitResult));
        }
        return Pair.of(null, (Object)InteractionResult.PASS);
    }

    protected InteractionResult onHardHammerClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        MetaMachine metaMachine = this;
        if (metaMachine instanceof IMufflableMachine) {
            IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)metaMachine);
            if (!this.isRemote()) {
                mufflableMachine.setMuffled(!mufflableMachine.isMuffled());
                playerIn.m_213846_((Component)Component.m_237115_((String)(mufflableMachine.isMuffled() ? "gtceu.machine.muffle.on" : "gtceu.machine.muffle.off")));
            }
            playerIn.m_6674_(hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult onCrowbarClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        MetaMachine metaMachine;
        if (playerIn.m_6144_()) {
            if (gridSide == this.getFrontFacing() || !this.isFacingValid(gridSide)) {
                return InteractionResult.FAIL;
            }
            if (!this.isRemote()) {
                this.setFrontFacing(gridSide);
            }
            playerIn.m_6674_(hand);
            return InteractionResult.CONSUME;
        }
        if (this.isRemote()) {
            return InteractionResult.CONSUME;
        }
        ItemStack itemStack = playerIn.m_21120_(hand);
        CompoundTag tagCompound = ToolHelper.getBehaviorsTag(itemStack);
        ToolModeSwitchBehavior.WrenchModeType type = ToolModeSwitchBehavior.WrenchModeType.values()[tagCompound.m_128445_("Mode")];
        if ((type == ToolModeSwitchBehavior.WrenchModeType.ITEM || type == ToolModeSwitchBehavior.WrenchModeType.BOTH) && (metaMachine = this) instanceof IAutoOutputItem) {
            IAutoOutputItem autoOutputItem = (IAutoOutputItem)((Object)metaMachine);
            if (!this.hasFrontFacing() || gridSide != this.getFrontFacing()) {
                autoOutputItem.setOutputFacingItems(gridSide);
            }
        }
        if ((type == ToolModeSwitchBehavior.WrenchModeType.FLUID || type == ToolModeSwitchBehavior.WrenchModeType.BOTH) && (metaMachine = this) instanceof IAutoOutputFluid) {
            IAutoOutputFluid autoOutputFluid = (IAutoOutputFluid)((Object)metaMachine);
            if (!this.hasFrontFacing() || gridSide != this.getFrontFacing()) {
                autoOutputFluid.setOutputFacingFluids(gridSide);
            }
        }
        playerIn.m_6674_(hand);
        return InteractionResult.CONSUME;
    }

    protected InteractionResult onSoftMalletClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        IControllable controllable = GTCapabilityHelper.getControllable(this.getLevel(), this.getPos(), gridSide);
        if (controllable != null) {
            if (!this.isRemote()) {
                if (!playerIn.m_6144_() || !controllable.isWorkingEnabled()) {
                    controllable.setWorkingEnabled(!controllable.isWorkingEnabled());
                    playerIn.m_213846_((Component)Component.m_237115_((String)(controllable.isWorkingEnabled() ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled")));
                } else {
                    controllable.setSuspendAfterFinish(true);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"behaviour.soft_hammer.idle_after_cycle"));
                }
            }
            playerIn.m_6674_(hand);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        ItemStack itemStack = playerIn.m_21120_(hand);
        CompoundTag tagCompound = ToolHelper.getBehaviorsTag(itemStack);
        if (this.isRemote()) {
            return InteractionResult.CONSUME;
        }
        if (playerIn.m_6144_()) {
            IAutoOutputFluid autoOutputFluid;
            IAutoOutputItem autoOutputItem;
            boolean flag = false;
            MetaMachine metaMachine = this;
            if (metaMachine instanceof IAutoOutputItem && (autoOutputItem = (IAutoOutputItem)((Object)metaMachine)).getOutputFacingItems() == gridSide) {
                autoOutputItem.setAllowInputFromOutputSideItems(!autoOutputItem.isAllowInputFromOutputSideItems());
                playerIn.m_5661_((Component)Component.m_237115_((String)("gtceu.machine.basic.input_from_output_side." + (autoOutputItem.isAllowInputFromOutputSideItems() ? "allow" : "disallow"))).m_7220_((Component)Component.m_237115_((String)"gtceu.creative.chest.item")), true);
                flag = true;
            }
            if ((metaMachine = this) instanceof IAutoOutputFluid && (autoOutputFluid = (IAutoOutputFluid)((Object)metaMachine)).getOutputFacingFluids() == gridSide) {
                autoOutputFluid.setAllowInputFromOutputSideFluids(!autoOutputFluid.isAllowInputFromOutputSideFluids());
                playerIn.m_5661_((Component)Component.m_237115_((String)("gtceu.machine.basic.input_from_output_side." + (autoOutputFluid.isAllowInputFromOutputSideFluids() ? "allow" : "disallow"))).m_7220_((Component)Component.m_237115_((String)"gtceu.creative.tank.fluid")), true);
                flag = true;
            }
            if (flag) {
                playerIn.m_6674_(hand);
                return InteractionResult.SUCCESS;
            }
        } else {
            IAutoOutputFluid autoOutputFluid;
            IAutoOutputItem autoOutputItem;
            boolean flag = false;
            MetaMachine metaMachine = this;
            if (metaMachine instanceof IAutoOutputItem && (autoOutputItem = (IAutoOutputItem)((Object)metaMachine)).getOutputFacingItems() == gridSide) {
                autoOutputItem.setAutoOutputItems(!autoOutputItem.isAutoOutputItems());
                flag = true;
            }
            if ((metaMachine = this) instanceof IAutoOutputFluid && (autoOutputFluid = (IAutoOutputFluid)((Object)metaMachine)).getOutputFacingFluids() == gridSide) {
                autoOutputFluid.setAutoOutputFluids(!autoOutputFluid.isAutoOutputFluids());
                flag = true;
            }
            if (flag) {
                playerIn.m_6674_(hand);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public static MetaMachine getMachine(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMachineBlockEntity) {
            IMachineBlockEntity machineBlockEntity = (IMachineBlockEntity)blockEntity;
            return machineBlockEntity.getMetaMachine();
        }
        return null;
    }

    public void attachTraits(MachineTrait trait) {
        this.traits.add(trait);
    }

    public void clearInventory(IItemHandlerModifiable inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stackInSlot = inventory.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            inventory.setStackInSlot(i, ItemStack.f_41583_);
            Block.m_49840_((Level)this.getLevel(), (BlockPos)this.getPos(), (ItemStack)stackInSlot);
        }
    }

    @Override
    public boolean shouldRenderGrid(Player player, BlockPos pos, BlockState state, ItemStack held, Set<GTToolType> toolTypes) {
        if (toolTypes.contains(GTToolType.WRENCH)) {
            return true;
        }
        if (toolTypes.contains(GTToolType.SCREWDRIVER) && (this instanceof IAutoOutputItem || this instanceof IAutoOutputFluid)) {
            return true;
        }
        for (CoverBehavior cover : this.coverContainer.getCovers()) {
            if (!cover.shouldRenderGrid(player, pos, state, held, toolTypes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        MetaMachine metaMachine;
        ResourceTexture tips;
        CoverBehavior cover = this.coverContainer.getCoverAtSide(side);
        if (cover != null && (tips = cover.sideTips(player, pos, state, toolTypes, side)) != null) {
            return tips;
        }
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (player.m_6144_() && this.isFacingValid(side)) {
                return GuiTextures.TOOL_FRONT_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            MetaMachine metaMachine2 = this;
            if (metaMachine2 instanceof IControllable) {
                IControllable controllable = (IControllable)((Object)metaMachine2);
                return controllable.isWorkingEnabled() ? GuiTextures.TOOL_START : GuiTextures.TOOL_PAUSE;
            }
        } else if (toolTypes.contains(GTToolType.HARD_HAMMER) && (metaMachine = this) instanceof IMufflableMachine) {
            IMufflableMachine mufflableMachine = (IMufflableMachine)((Object)metaMachine);
            return mufflableMachine.isMuffled() ? GuiTextures.TOOL_SOUND : GuiTextures.TOOL_MUTE;
        }
        return null;
    }

    public MachineDefinition getDefinition() {
        return this.holder.getDefinition();
    }

    public void addCollisionBoundingBox(List<VoxelShape> collisionList) {
        collisionList.add(Shapes.m_83144_());
    }

    public boolean canSetIoOnSide(@Nullable Direction direction) {
        return !this.hasFrontFacing() || this.getFrontFacing() != direction;
    }

    public Direction getFrontFacing() {
        BlockState blockState = this.getBlockState();
        Block block = blockState.m_60734_();
        if (block instanceof MetaMachineBlock) {
            MetaMachineBlock machineBlock = (MetaMachineBlock)block;
            return machineBlock.getFrontFacing(blockState);
        }
        return Direction.NORTH;
    }

    public final boolean hasFrontFacing() {
        BlockState blockState = this.getBlockState();
        Block block = blockState.m_60734_();
        if (block instanceof MetaMachineBlock) {
            MetaMachineBlock machineBlock = (MetaMachineBlock)block;
            return machineBlock.getRotationState() != RotationState.NONE;
        }
        return false;
    }

    public boolean isFacingValid(Direction facing) {
        if (this.hasFrontFacing() && facing == this.getFrontFacing()) {
            return false;
        }
        BlockState blockState = this.getBlockState();
        Block block = blockState.m_60734_();
        if (block instanceof MetaMachineBlock) {
            MetaMachineBlock metaMachineBlock = (MetaMachineBlock)block;
            return metaMachineBlock.rotationState.test(facing);
        }
        return false;
    }

    public void setFrontFacing(Direction facing) {
        BlockState blockState = this.getBlockState();
        Block block = blockState.m_60734_();
        if (block instanceof MetaMachineBlock) {
            MetaMachineBlock metaMachineBlock = (MetaMachineBlock)block;
            if (this.isFacingValid(facing)) {
                this.getLevel().m_46597_(this.getPos(), (BlockState)blockState.m_61124_((Property)metaMachineBlock.rotationState.property, (Comparable)facing));
            }
        }
    }

    public void onRotated(Direction oldFacing, Direction newFacing) {
    }

    public int tintColor(int index) {
        if (index == 1 || index == -111) {
            return this.getRealColor();
        }
        return -1;
    }

    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        this.coverContainer.onNeighborChanged(block, fromPos, isMoving);
    }

    public void animateTick(RandomSource random) {
    }

    @Override
    @NotNull
    public BlockState getBlockAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState sourceState, BlockPos sourcePos) {
        IMultiPart part;
        BlockState appearance = this.getCoverContainer().getBlockAppearance(state, level, pos, side, sourceState, sourcePos);
        if (appearance != null) {
            return appearance;
        }
        MetaMachine metaMachine = this;
        if (metaMachine instanceof IMultiPart && (part = (IMultiPart)((Object)metaMachine)).isFormed() && (appearance = part.getFormedAppearance(sourceState, sourcePos, side)) != null) {
            return appearance;
        }
        return this.getDefinition().getAppearance().get();
    }

    @Override
    public int getOutputSignal(@Nullable Direction side) {
        if (side == null) {
            return 0;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side.m_122424_());
        if (cover == null) {
            return 0;
        }
        return cover.getRedstoneSignalOutput();
    }

    @Override
    public boolean canConnectRedstone(Direction side) {
        if (side == null) {
            return false;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        if (cover == null) {
            return false;
        }
        return cover.canConnectRedstone();
    }

    public Predicate<ItemStack> getItemCapFilter(@Nullable Direction side, IO io) {
        ItemFilterCover filterCover;
        CoverBehavior cover;
        if (side != null && (cover = this.getCoverContainer().getCoverAtSide(side)) instanceof ItemFilterCover && (filterCover = (ItemFilterCover)cover).getFilterMode().filters(io)) {
            return filterCover.getItemFilter();
        }
        return item -> true;
    }

    public Predicate<FluidStack> getFluidCapFilter(@Nullable Direction side, IO io) {
        FluidFilterCover filterCover;
        CoverBehavior cover;
        if (side != null && (cover = this.getCoverContainer().getCoverAtSide(side)) instanceof FluidFilterCover && (filterCover = (FluidFilterCover)cover).getFilterMode().filters(io)) {
            return filterCover.getFluidFilter();
        }
        return fluid -> true;
    }

    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        IAutoOutputItem autoOutput;
        MetaMachine metaMachine;
        List<IItemHandlerModifiable> list = this.getTraits().stream().filter(IItemHandlerModifiable.class::isInstance).filter(t -> t.hasCapability(side)).map(IItemHandlerModifiable.class::cast).toList();
        if (list.isEmpty()) {
            return null;
        }
        IO io = IO.BOTH;
        if (side != null && (metaMachine = this) instanceof IAutoOutputItem && (autoOutput = (IAutoOutputItem)((Object)metaMachine)).getOutputFacingItems() == side && !autoOutput.isAllowInputFromOutputSideItems()) {
            io = IO.OUT;
        }
        IOFilteredInvWrapper handlerList = new IOFilteredInvWrapper(list, io, this.getItemCapFilter(side, IO.IN), this.getItemCapFilter(side, IO.OUT));
        if (!useCoverCapability || side == null) {
            return handlerList;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getItemHandlerCap((IItemHandlerModifiable)handlerList) : handlerList;
    }

    @Nullable
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        IAutoOutputFluid autoOutput;
        MetaMachine metaMachine;
        List<IFluidHandler> list = this.getTraits().stream().filter(IFluidHandler.class::isInstance).filter(t -> t.hasCapability(side)).map(IFluidHandler.class::cast).toList();
        if (list.isEmpty()) {
            return null;
        }
        IO io = IO.BOTH;
        if (side != null && (metaMachine = this) instanceof IAutoOutputFluid && (autoOutput = (IAutoOutputFluid)((Object)metaMachine)).getOutputFacingFluids() == side && !autoOutput.isAllowInputFromOutputSideFluids()) {
            io = IO.OUT;
        }
        IOFluidHandlerList handlerList = new IOFluidHandlerList(list, io, this.getFluidCapFilter(side, IO.IN), this.getFluidCapFilter(side, IO.OUT));
        if (!useCoverCapability || side == null) {
            return handlerList;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getFluidHandlerCap(handlerList) : handlerList;
    }

    @Override
    public IGuiTexture getFancyTooltipIcon() {
        return GuiTextures.INFO_ICON;
    }

    @Override
    public final List<Component> getFancyTooltip() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        this.onAddFancyInformationTooltip(tooltips);
        return tooltips;
    }

    @Override
    public boolean showFancyTooltip() {
        return !this.getFancyTooltip().isEmpty();
    }

    public void onAddFancyInformationTooltip(List<Component> tooltips) {
        this.getDefinition().getTooltipBuilder().accept(this.getDefinition().asStack(), tooltips);
        String mainKey = String.format("%s.machine.%s.tooltip", this.getDefinition().getId().m_135827_(), this.getDefinition().getId().m_135815_());
        if (LocalizationUtils.exist((String)mainKey)) {
            tooltips.add(0, (Component)Component.m_237115_((String)mainKey));
        }
    }

    @Override
    public int getDefaultPaintingColor() {
        return this.getDefinition().getDefaultPaintingColor();
    }

    @Generated
    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    @Generated
    public IMachineBlockEntity getHolder() {
        return this.holder;
    }

    @Generated
    public MachineCoverContainer getCoverContainer() {
        return this.coverContainer;
    }

    @Override
    @Generated
    public int getPaintingColor() {
        return this.paintingColor;
    }

    @Override
    @Generated
    public void setPaintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
    }

    @Generated
    public List<MachineTrait> getTraits() {
        return this.traits;
    }
}

