/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.ReadOnlyManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import java.util.ArrayList;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class MachineCoverContainer
implements ICoverable,
IEnhancedManaged {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MachineCoverContainer.class);
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
    private final MetaMachine machine;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior up;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior down;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior north;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior south;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior west;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior east;

    public MachineCoverContainer(MetaMachine machine) {
        this.machine = machine;
    }

    private void onCoverSet(CoverBehavior newValue, CoverBehavior oldValue) {
        if (newValue != oldValue && (newValue == null || oldValue == null)) {
            this.scheduleRenderUpdate();
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        Level level = this.getLevel();
        if (level != null && !level.f_46443_ && level.m_7654_() != null) {
            level.m_7654_().execute(this::markDirty);
        }
    }

    @Override
    public Level getLevel() {
        return this.machine.getLevel();
    }

    @Override
    public BlockPos getPos() {
        return this.machine.getPos();
    }

    @Override
    public long getOffsetTimer() {
        return this.machine.getOffsetTimer();
    }

    @Override
    public void markDirty() {
        this.machine.markDirty();
    }

    @Override
    public void notifyBlockUpdate() {
        this.machine.notifyBlockUpdate();
    }

    @Override
    public void scheduleRenderUpdate() {
        this.machine.scheduleRenderUpdate();
    }

    @Override
    public void scheduleNeighborShapeUpdate() {
        this.machine.scheduleNeighborShapeUpdate();
    }

    @Override
    public boolean isInValid() {
        return this.machine.isInValid();
    }

    @Override
    public boolean canPlaceCoverOnSide(CoverDefinition definition, Direction side) {
        ArrayList<VoxelShape> collisionList = new ArrayList<VoxelShape>();
        this.machine.addCollisionBoundingBox(collisionList);
        return !ICoverable.doesCoverCollide(side, collisionList, this.getCoverPlateThickness());
    }

    @Override
    public double getCoverPlateThickness() {
        return 0.0;
    }

    @Override
    public Direction getFrontFacing() {
        return this.machine.getFrontFacing();
    }

    @Override
    public boolean shouldRenderBackSide() {
        return !this.machine.getBlockState().m_60815_();
    }

    @Override
    @Nullable
    public TickableSubscription subscribeServerTick(Runnable runnable) {
        return this.machine.subscribeServerTick(runnable);
    }

    @Override
    public void unsubscribe(@Nullable TickableSubscription current) {
        this.machine.unsubscribe(current);
    }

    @Override
    public CoverBehavior getCoverAtSide(Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> this.up;
            case Direction.SOUTH -> this.south;
            case Direction.WEST -> this.west;
            case Direction.DOWN -> this.down;
            case Direction.EAST -> this.east;
            case Direction.NORTH -> this.north;
        };
    }

    @Override
    public void setCoverAtSide(@Nullable CoverBehavior coverBehavior, Direction side) {
        switch (side) {
            case UP: {
                this.up = coverBehavior;
                break;
            }
            case SOUTH: {
                this.south = coverBehavior;
                break;
            }
            case WEST: {
                this.west = coverBehavior;
                break;
            }
            case DOWN: {
                this.down = coverBehavior;
                break;
            }
            case EAST: {
                this.east = coverBehavior;
                break;
            }
            case NORTH: {
                this.north = coverBehavior;
            }
        }
        if (coverBehavior != null) {
            coverBehavior.getSyncStorage().markAllDirty();
        }
    }

    @Override
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        return this.machine.getItemHandlerCap(side, useCoverCapability);
    }

    @Override
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        return this.machine.getFluidHandlerCap(side, useCoverCapability);
    }

    private boolean onCoverDirty(CoverBehavior coverBehavior) {
        if (coverBehavior != null) {
            for (IRef ref : coverBehavior.getSyncStorage().getNonLazyFields()) {
                ref.update();
            }
            return coverBehavior.getSyncStorage().hasDirtySyncFields() || coverBehavior.getSyncStorage().hasDirtyPersistedFields();
        }
        return false;
    }

    private CompoundTag serializeCoverUid(CoverBehavior coverBehavior) {
        CompoundTag uid = new CompoundTag();
        uid.m_128359_("id", ((ResourceLocation)GTRegistries.COVERS.getKey(coverBehavior.coverDefinition)).toString());
        uid.m_128405_("side", coverBehavior.attachedSide.ordinal());
        return uid;
    }

    private CoverBehavior deserializeCoverUid(CompoundTag uid) {
        ResourceLocation definitionId = new ResourceLocation(uid.m_128461_("id"));
        Direction side = GTUtil.DIRECTIONS[uid.m_128451_("side")];
        CoverDefinition definition = (CoverDefinition)GTRegistries.COVERS.get(definitionId);
        if (definition != null) {
            return definition.createCoverBehavior(this, side);
        }
        GTCEu.LOGGER.error("couldn't find cover definition {}", (Object)definitionId);
        throw new RuntimeException();
    }

    @Generated
    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }
}

