/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.google.common.collect.Multimap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IGTToolDefinition;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.client.renderer.item.ToolItemRenderer;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class GTShovelItem
extends ShovelItem
implements IGTTool {
    private final GTToolType toolType;
    private final Material material;
    private final int electricTier;
    private final IGTToolDefinition toolStats;

    protected GTShovelItem(GTToolType toolType, MaterialToolTier tier, Material material, IGTToolDefinition toolStats, Item.Properties properties) {
        super((Tier)tier, 0.0f, 0.0f, properties);
        this.toolType = toolType;
        this.material = material;
        this.electricTier = toolType.electricTier;
        this.toolStats = toolStats;
        if (GTCEu.isClientSide()) {
            ToolItemRenderer.create((Item)this, toolType);
        }
        this.definition$init();
    }

    public static GTShovelItem create(GTToolType toolType, MaterialToolTier tier, Material material, IGTToolDefinition toolStats, Item.Properties properties) {
        return new GTShovelItem(toolType, tier, material, toolStats, properties);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return this.definition$initCapabilities(stack, nbt);
    }

    public ItemStack m_7968_() {
        return this.get();
    }

    public boolean m_41470_() {
        return super.m_41470_();
    }

    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        return this.definition$onItemUseFirst(itemStack, context);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (context.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        BlockState modifiedState = blockstate.getToolModifiedState(context, ToolActions.SHOVEL_FLATTEN, false);
        BlockState resultState = null;
        if (modifiedState != null && level.m_46859_(blockpos.m_7494_())) {
            level.m_5594_(player, blockpos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
            resultState = modifiedState;
        } else if (blockstate.m_60734_() instanceof CampfireBlock && ((Boolean)blockstate.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            if (!level.m_5776_()) {
                level.m_5898_(null, 1009, blockpos, 0);
            }
            CampfireBlock.m_152749_((Entity)context.m_43723_(), (LevelAccessor)level, (BlockPos)blockpos, (BlockState)blockstate);
            resultState = (BlockState)blockstate.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
        }
        if (resultState != null) {
            if (!level.f_46443_) {
                level.m_7731_(blockpos, resultState, 11);
                level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)resultState));
                if (player != null) {
                    context.m_43722_().m_41622_(1, (LivingEntity)player, breaker -> breaker.m_21190_(context.m_43724_()));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public String m_5524_() {
        return this.toolType.getUnlocalizedName();
    }

    public Component m_41466_() {
        return Component.m_237110_((String)this.toolType.getUnlocalizedName(), (Object[])new Object[]{this.material.getLocalizedName()});
    }

    public Component m_7626_(ItemStack stack) {
        return this.m_41466_();
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        return this.definition$mineBlock(stack, level, state, pos, miningEntity);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        return this.definition$use(level, player, usedHand);
    }

    @Override
    public boolean isElectric() {
        return this.electricTier > -1;
    }

    @Override
    @Nullable
    public SoundEntry getSound() {
        return this.toolType.soundEntry;
    }

    @Override
    public boolean playSoundOnBlockDestroy() {
        return this.toolType.playSoundOnBlockDestroy;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.definition$getDestroySpeed(stack, state);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.definition$hurtEnemy(stack, target, attacker);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        return this.definition$onBlockStartBreak(stack, pos, player);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        this.definition$appendHoverText(stack, level, tooltipComponents, isAdvanced);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.definition$canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.getTotalEnchantability(stack);
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairCandidate) {
        return this.definition$isValidRepairItem(stack, repairCandidate);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return this.definition$getDefaultAttributeModifiers(slot, stack);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return this.definition$canDisableShield(shield, shield, entity, attacker);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return this.definition$doesSneakBypassUse(stack, (BlockGetter)level, pos, player);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return this.definition$shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return this.definition$hasCraftingRemainingItem(stack);
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return this.definition$getCraftingRemainingItem(itemStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return this.definition$shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean isDamaged(ItemStack stack) {
        return this.definition$isDamaged(stack);
    }

    public int getDamage(ItemStack stack) {
        return this.definition$getDamage(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.definition$getMaxDamage(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        this.definition$setDamage(stack, damage);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.definition$isCorrectToolForDrops(stack, state);
    }

    @Override
    @Generated
    public GTToolType getToolType() {
        return this.toolType;
    }

    @Override
    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Override
    @Generated
    public int getElectricTier() {
        return this.electricTier;
    }

    @Override
    @Generated
    public IGTToolDefinition getToolStats() {
        return this.toolStats;
    }
}

