/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ExtendedProgressWidget
extends ProgressWidget {
    private List<Component> serverTooltips = new ArrayList<Component>();
    private Consumer<List<Component>> serverTooltipSupplier;

    public ExtendedProgressWidget() {
        super(JEIProgress, 0, 0, 40, 40, new ProgressTexture());
    }

    public ExtendedProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, ResourceTexture fullImage) {
        super(progressSupplier, x, y, width, height, fullImage);
    }

    public ExtendedProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height, ProgressTexture progressBar) {
        super(progressSupplier, x, y, width, height, progressBar);
    }

    public ExtendedProgressWidget(DoubleSupplier progressSupplier, int x, int y, int width, int height) {
        super(progressSupplier, x, y, width, height);
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.serverTooltipSupplier != null) {
            ArrayList<Component> textBuffer = new ArrayList<Component>();
            this.serverTooltipSupplier.accept(textBuffer);
            if (!this.serverTooltips.equals(textBuffer)) {
                this.serverTooltips = textBuffer;
                this.writeUpdateInfo(1, buffer -> {
                    buffer.m_130130_(this.serverTooltips.size());
                    for (Component component : this.serverTooltips) {
                        buffer.m_130083_(component);
                    }
                });
            }
        }
    }

    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == 1) {
            this.serverTooltips.clear();
            int count = buffer.m_130242_();
            for (int i = 0; i < count; ++i) {
                Component component = buffer.m_130238_();
                this.serverTooltips.add(component);
            }
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!(this.tooltipTexts.isEmpty() && this.serverTooltips.isEmpty() || !this.isMouseOverElement(mouseX, mouseY) || this.getHoverElement(mouseX, mouseY) != this || this.gui == null || this.gui.getModularUIGui() == null)) {
            ArrayList<Component> tips = new ArrayList<Component>(this.tooltipTexts);
            tips.addAll(this.serverTooltips);
            this.gui.getModularUIGui().setHoverTooltip(tips, ItemStack.f_41583_, null, null);
        }
    }

    @Generated
    public ExtendedProgressWidget setServerTooltipSupplier(Consumer<List<Component>> serverTooltipSupplier) {
        this.serverTooltipSupplier = serverTooltipSupplier;
        return this;
    }
}

