/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.editor;

import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.gui.editor.UIMainPanel;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.data.UIProject;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.tool.WidgetToolBox;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.TabButton;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@LDLRegister(name="mui", group="editor.gtceu")
public class MachineUIProject
extends UIProject {
    @Nullable
    protected MachineDefinition machineDefinition;

    private MachineUIProject() {
        this(null, null);
    }

    public MachineUIProject(Resources resources, WidgetGroup root) {
        super(resources, root);
    }

    public MachineUIProject(CompoundTag tag) {
        super(tag);
    }

    public void setMachine(@Nullable MachineDefinition machineDefinition) {
        this.machineDefinition = machineDefinition;
    }

    public MachineUIProject newEmptyProject() {
        return new MachineUIProject(Resources.defaultResource(), new WidgetGroup(30, 30, 200, 150));
    }

    public UIProject loadProject(File file) {
        try {
            CompoundTag tag = NbtIo.m_128953_((File)file);
            if (tag != null) {
                return new MachineUIProject(tag);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        if (this.machineDefinition != null) {
            tag.m_128359_("machine", this.machineDefinition.getId().toString());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        if (tag.m_128441_("machine")) {
            this.machineDefinition = (MachineDefinition)GTRegistries.MACHINES.get(new ResourceLocation(tag.m_128461_("machine")));
        }
    }

    public void onLoad(Editor editor) {
        editor.getResourcePanel().loadResource(this.getResources(), false);
        editor.getTabPages().addTab(new TabButton(50, 16, 60, 14).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GREEN.rectTexture().setBottomRadius(10.0f).transform(0.0f, 0.4f), new TextTexture("Main")}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_RED.rectTexture().setBottomRadius(10.0f).transform(0.0f, 0.4f), new TextTexture("Main")})), (WidgetGroup)new UIMainPanel(editor, this.root, this.machineDefinition == null ? null : this.machineDefinition.getDescriptionId()));
        for (WidgetToolBox.Default tab : WidgetToolBox.Default.TABS) {
            editor.getToolPanel().addNewToolBox("ldlib.gui.editor.group." + tab.groupName, tab.icon, (WidgetGroup)tab.createToolBox());
        }
    }

    public void attachMenu(Editor editor, String name, TreeBuilder.Menu menu) {
        if (name.equals("file")) {
            if (this.machineDefinition == null || this.machineDefinition.getEditableUI() == null) {
                menu.remove("ldlib.gui.editor.menu.save");
            } else {
                menu.remove("ldlib.gui.editor.menu.save");
                menu.leaf((IGuiTexture)Icons.SAVE, "ldlib.gui.editor.menu.save", () -> {
                    EditableMachineUI editableUI = this.machineDefinition.getEditableUI();
                    File path = new File(LDLib.location, "assets/%s/ui/machine".formatted(editableUI.getUiPath().m_135827_()));
                    path.mkdirs();
                    this.saveProject(new File(path, editableUI.getUiPath().m_135815_() + "." + this.getRegisterUI().name()));
                    editableUI.reloadCustomUI();
                });
            }
        } else if (name.equals("template_tab")) {
            LinkedHashMap<String, List> categories = new LinkedHashMap<String, List>();
            for (MachineDefinition definition : GTRegistries.MACHINES) {
                EditableMachineUI editableUI = definition.getEditableUI();
                if (editableUI == null) continue;
                categories.computeIfAbsent(editableUI.getGroupName(), group -> new ArrayList()).add(definition);
            }
            categories.forEach((groupName, definitions) -> menu.branch(groupName, m -> {
                HashSet<EditableMachineUI> addedSet = new HashSet<EditableMachineUI>();
                for (MachineDefinition definition : definitions) {
                    EditableMachineUI editableUI = definition.getEditableUI();
                    if (editableUI == null || !addedSet.add(editableUI)) continue;
                    m.leaf((IGuiTexture)new ItemStackTexture(new ItemStack[]{definition.asStack()}), definition.getDescriptionId(), () -> {
                        this.root.clearAllWidgets();
                        if (editableUI.hasCustomUI()) {
                            this.deserializeNBT(editableUI.getCustomUI());
                        } else {
                            WidgetGroup template = editableUI.createDefault();
                            template.setSelfPosition(new Position(this.root.getSelfPosition().x, this.root.getSelfPosition().y));
                            this.root = template;
                        }
                        this.setMachine(definition);
                        editor.loadProject((IProject)this);
                    });
                }
            }));
        }
    }

    @Nullable
    @Generated
    public MachineDefinition getMachineDefinition() {
        return this.machineDefinition;
    }
}

