/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockore;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.OreVeinWorldEntry;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BedrockOreVeinSavedData
extends SavedData {
    public static final int VEIN_CHUNK_SIZE = 3;
    public static final int MAXIMUM_VEIN_OPERATIONS = 100000;
    public final HashMap<ChunkPos, OreVeinWorldEntry> veinOres = new HashMap();
    private final HashMap<Holder<Biome>, Integer> biomeWeights = new HashMap();
    private final ServerLevel serverLevel;

    public static BedrockOreVeinSavedData getOrCreate(ServerLevel serverLevel) {
        return (BedrockOreVeinSavedData)serverLevel.m_8895_().m_164861_(tag -> new BedrockOreVeinSavedData(serverLevel, (CompoundTag)tag), () -> new BedrockOreVeinSavedData(serverLevel), "gtceu_bedrock_ore");
    }

    public BedrockOreVeinSavedData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    public BedrockOreVeinSavedData(ServerLevel serverLevel, CompoundTag nbt) {
        this(serverLevel);
        ListTag list = nbt.m_128437_("veinInfo", 10);
        for (Tag tag : list) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)tag;
            ChunkPos chunkPos = new ChunkPos(compoundTag.m_128454_("pos"));
            this.veinOres.put(chunkPos, OreVeinWorldEntry.readFromNBT(compoundTag.m_128469_("data")));
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag oreList = new ListTag();
        for (Map.Entry<ChunkPos, OreVeinWorldEntry> entry : this.veinOres.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("pos", entry.getKey().m_45588_());
            tag.m_128365_("data", (Tag)entry.getValue().writeToNBT());
            oreList.add((Object)tag);
        }
        nbt.m_128365_("veinInfo", (Tag)oreList);
        return nbt;
    }

    public static int getVeinCoord(int chunkCoord) {
        return Math.floorDiv(chunkCoord, 3);
    }

    public OreVeinWorldEntry getOreVeinWorldEntry(int chunkX, int chunkZ) {
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        if (!this.veinOres.containsKey(pos)) {
            int minDistance = ConfigHolder.INSTANCE.worldgen.oreVeins.bedrockOreDistance;
            if (chunkX % minDistance != 0 || chunkZ % minDistance != 0) {
                OreVeinWorldEntry entry = new OreVeinWorldEntry(null, 0, 100000);
                this.veinOres.put(pos, entry);
                return entry;
            }
            BedrockOreDefinition definition = null;
            int query = RandomSource.m_216335_((long)Objects.hash(this.serverLevel.m_7328_(), BedrockOreVeinSavedData.getVeinCoord(chunkX), BedrockOreVeinSavedData.getVeinCoord(chunkZ))).m_188502_();
            Holder biome = this.serverLevel.m_204166_(new BlockPos(chunkX << 4, 64, chunkZ << 4));
            int totalWeight = this.getTotalWeight((Holder<Biome>)biome);
            if (totalWeight > 0) {
                int weight = Math.abs(query % totalWeight);
                for (BedrockOreDefinition oreDefinition : GTRegistries.BEDROCK_ORE_DEFINITIONS) {
                    int veinWeight = oreDefinition.weight() + (oreDefinition.biomeWeightModifier() != null ? oreDefinition.biomeWeightModifier().apply((Holder<Biome>)biome) : 0);
                    if (veinWeight <= 0 || oreDefinition.dimensionFilter != null && !oreDefinition.dimensionFilter().stream().anyMatch(dim -> WorldGeneratorUtils.isSameDimension((ResourceKey<Level>)dim, (ResourceKey<Level>)this.serverLevel.m_46472_())) || (weight -= veinWeight) >= 0) continue;
                    definition = oreDefinition;
                    break;
                }
            }
            this.createVein(pos, definition);
            this.m_77762_();
        }
        if (!this.veinOres.containsKey(pos)) {
            OreVeinWorldEntry entry = new OreVeinWorldEntry(null, 0, 100000);
            this.veinOres.put(pos, entry);
            return entry;
        }
        return this.veinOres.get(pos);
    }

    public void createVein(ChunkPos pos, @Nullable BedrockOreDefinition definition) {
        if (definition != null) {
            int radius = definition.size() / 2;
            for (int x = pos.f_45578_ - radius; x <= pos.f_45578_ + radius; ++x) {
                for (int z = pos.f_45579_ - radius; z <= pos.f_45579_ + radius; ++z) {
                    int maximumYield;
                    ChunkPos pos2 = new ChunkPos(x, z);
                    float distanceFromOriginal = Math.abs(pos.f_45578_ - x) + Math.abs(pos.f_45579_ - z);
                    distanceFromOriginal = distanceFromOriginal == 0.0f ? 1.0f : distanceFromOriginal;
                    distanceFromOriginal = (float)Math.pow(distanceFromOriginal, 2.0);
                    RandomSource random = RandomSource.m_216335_((long)(961L * (long)pos2.f_45578_ + (long)pos2.f_45579_ * 31L + (long)Long.hashCode(this.serverLevel.m_7328_())));
                    if ((float)(definition.yield().m_142737_() - definition.yield().m_142739_()) / distanceFromOriginal <= 0.0f) {
                        maximumYield = definition.yield().m_142739_();
                    } else {
                        maximumYield = (int)((float)(definition.yield().m_214085_(random) + definition.yield().m_142739_()) / distanceFromOriginal);
                        maximumYield = Math.max(maximumYield, definition.yield().m_142739_());
                    }
                    maximumYield = Math.min(maximumYield, definition.yield().m_142737_());
                    this.veinOres.put(pos2, new OreVeinWorldEntry(definition, maximumYield, 100000));
                }
            }
        }
    }

    public int getTotalWeight(Holder<Biome> biome) {
        return this.biomeWeights.computeIfAbsent(biome, b -> {
            int totalWeight = 0;
            for (BedrockOreDefinition definition : GTRegistries.BEDROCK_ORE_DEFINITIONS) {
                if (definition.dimensionFilter != null && !definition.dimensionFilter().stream().anyMatch(dim -> WorldGeneratorUtils.isSameDimension((ResourceKey<Level>)dim, (ResourceKey<Level>)this.serverLevel.m_46472_()))) continue;
                totalWeight += definition.biomeWeightModifier() != null ? definition.biomeWeightModifier().apply(biome) : 0;
                totalWeight += definition.weight();
            }
            return totalWeight;
        });
    }

    public int getOreYield(int chunkX, int chunkZ) {
        return this.getOreVeinWorldEntry(chunkX, chunkZ).getOreYield();
    }

    public int getDepletedOreYield(int chunkX, int chunkZ) {
        OreVeinWorldEntry info = this.getOreVeinWorldEntry(chunkX, chunkZ);
        if (info.getDefinition() == null) {
            return 0;
        }
        return info.getDefinition().depletedYield();
    }

    public int getOperationsRemaining(int chunkX, int chunkZ) {
        return this.getOreVeinWorldEntry(chunkX, chunkZ).getOperationsRemaining();
    }

    @Nullable
    public List<Map.Entry<Integer, Material>> getOreInChunk(int chunkX, int chunkZ) {
        OreVeinWorldEntry info = this.getOreVeinWorldEntry(chunkX, chunkZ);
        if (info.getDefinition() == null) {
            return null;
        }
        return info.getDefinition().materials().stream().map(pair -> Map.entry((Integer)pair.getSecond(), (Material)pair.getFirst())).collect(Collectors.toList());
    }

    public void depleteVein(int chunkX, int chunkZ, int amount, boolean ignoreVeinStats) {
        OreVeinWorldEntry info = this.getOreVeinWorldEntry(chunkX, chunkZ);
        if (ignoreVeinStats) {
            info.decreaseOperations(amount);
            if (amount != 0) {
                this.m_77762_();
            }
            return;
        }
        BedrockOreDefinition definition = info.getDefinition();
        if (definition == null || definition.depletionChance() == 0) {
            return;
        }
        if (definition.depletionChance() == 100 || GTValues.RNG.m_188503_(100) <= definition.depletionChance()) {
            info.decreaseOperations(definition.depletionAmount());
            this.m_77762_();
        }
    }
}

