/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid;

import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.utils.RegistryUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;

public class BedrockFluidDefinition {
    public static final MapCodec<Pair<Integer, Integer>> YIELD = Codec.mapPair((MapCodec)Codec.INT.fieldOf("min"), (MapCodec)Codec.INT.fieldOf("max"));
    public static final Codec<BedrockFluidDefinition> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("weight").forGetter(ft -> ft.weight), (App)YIELD.fieldOf("yield").forGetter(ft -> Pair.of((Object)ft.minimumYield, (Object)ft.maximumYield)), (App)Codec.INT.fieldOf("depletion_amount").forGetter(ft -> ft.depletionAmount), (App)Codec.INT.fieldOf("depletion_chance").forGetter(ft -> ft.depletionChance), (App)Codec.INT.fieldOf("depleted_yield").forGetter(ft -> ft.depletedYield), (App)BuiltInRegistries.f_257020_.m_194605_().fieldOf("fluid").forGetter(ft -> ft.storedFluid.get()), (App)BiomeWeightModifier.CODEC.listOf().optionalFieldOf("weight_modifier", List.of()).forGetter(ft -> ft.originalModifiers), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).listOf().fieldOf("dimension_filter").forGetter(ft -> new ArrayList<ResourceKey<Level>>(ft.dimensionFilter))).apply((Applicative)instance, (weight, yield, depletionAmount, depletionChance, depletedYield, storedFluid, biomeWeightModifier, dimensionFilter) -> new BedrockFluidDefinition((int)weight, (Integer)yield.getFirst(), (Integer)yield.getSecond(), (int)depletionAmount, (int)depletionChance, (int)depletedYield, () -> storedFluid, (List<BiomeWeightModifier>)biomeWeightModifier, (Set<ResourceKey<Level>>)new HashSet<ResourceKey<Level>>((Collection<ResourceKey<Level>>)dimensionFilter))));
    private int weight;
    private int minimumYield;
    private int maximumYield;
    private int depletionAmount;
    private int depletionChance;
    private int depletedYield;
    private Supplier<Fluid> storedFluid;
    private BiomeWeightModifier biomeWeightModifier;
    private List<BiomeWeightModifier> originalModifiers;
    public Set<ResourceKey<Level>> dimensionFilter;

    public BedrockFluidDefinition(ResourceLocation name, int weight, int minimumYield, int maximumYield, int depletionAmount, int depletionChance, int depletedYield, Supplier<Fluid> storedFluid, List<BiomeWeightModifier> originalModifiers, Set<ResourceKey<Level>> dimensionFilter) {
        this(weight, minimumYield, maximumYield, depletionAmount, depletionChance, depletedYield, storedFluid, originalModifiers, dimensionFilter);
        GTRegistries.BEDROCK_FLUID_DEFINITIONS.register(name, this);
    }

    public BedrockFluidDefinition(int weight, int minimumYield, int maximumYield, int depletionAmount, int depletionChance, int depletedYield, Supplier<Fluid> storedFluid, final List<BiomeWeightModifier> originalModifiers, Set<ResourceKey<Level>> dimensionFilter) {
        this.weight = weight;
        this.minimumYield = minimumYield;
        this.maximumYield = maximumYield;
        this.depletionAmount = depletionAmount;
        this.depletionChance = depletionChance;
        this.depletedYield = depletedYield;
        this.storedFluid = storedFluid;
        this.originalModifiers = originalModifiers;
        this.biomeWeightModifier = new BiomeWeightModifier(() -> HolderSet.m_205800_(originalModifiers.stream().flatMap(mod -> mod.biomes.get().m_203614_()).toList()), originalModifiers.stream().mapToInt(mod -> mod.addedWeight).sum()){

            @Override
            public Integer apply(Holder<Biome> biome) {
                int mod = 0;
                for (BiomeWeightModifier modifier : originalModifiers) {
                    if (!modifier.biomes.get().m_203333_(biome)) continue;
                    mod += modifier.apply(biome).intValue();
                }
                return mod;
            }
        };
        this.dimensionFilter = dimensionFilter;
    }

    public void setOriginalModifiers(List<BiomeWeightModifier> modifiers) {
        this.originalModifiers = modifiers;
        this.biomeWeightModifier = new BiomeWeightModifier(() -> HolderSet.m_205800_(this.originalModifiers.stream().flatMap(mod -> mod.biomes.get().m_203614_()).toList()), this.originalModifiers.stream().mapToInt(mod -> mod.addedWeight).sum()){

            @Override
            public Integer apply(Holder<Biome> biome) {
                int mod = 0;
                for (BiomeWeightModifier modifier : BedrockFluidDefinition.this.originalModifiers) {
                    if (!modifier.biomes.get().m_203333_(biome)) continue;
                    mod += modifier.apply(biome).intValue();
                }
                return mod;
            }
        };
    }

    public static Builder builder(ResourceLocation name) {
        return new Builder(name);
    }

    @Generated
    public int getWeight() {
        return this.weight;
    }

    @Generated
    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Generated
    public int getMinimumYield() {
        return this.minimumYield;
    }

    @Generated
    public int getMaximumYield() {
        return this.maximumYield;
    }

    @Generated
    public void setMinimumYield(int minimumYield) {
        this.minimumYield = minimumYield;
    }

    @Generated
    public void setMaximumYield(int maximumYield) {
        this.maximumYield = maximumYield;
    }

    @Generated
    public int getDepletionAmount() {
        return this.depletionAmount;
    }

    @Generated
    public void setDepletionAmount(int depletionAmount) {
        this.depletionAmount = depletionAmount;
    }

    @Generated
    public int getDepletionChance() {
        return this.depletionChance;
    }

    @Generated
    public void setDepletionChance(int depletionChance) {
        this.depletionChance = depletionChance;
    }

    @Generated
    public int getDepletedYield() {
        return this.depletedYield;
    }

    @Generated
    public void setDepletedYield(int depletedYield) {
        this.depletedYield = depletedYield;
    }

    @Generated
    public Supplier<Fluid> getStoredFluid() {
        return this.storedFluid;
    }

    @Generated
    public void setStoredFluid(Supplier<Fluid> storedFluid) {
        this.storedFluid = storedFluid;
    }

    @Generated
    public BiomeWeightModifier getBiomeWeightModifier() {
        return this.biomeWeightModifier;
    }

    @Generated
    public Set<ResourceKey<Level>> getDimensionFilter() {
        return this.dimensionFilter;
    }

    @Generated
    public void setDimensionFilter(Set<ResourceKey<Level>> dimensionFilter) {
        this.dimensionFilter = dimensionFilter;
    }

    public static class Builder {
        private final ResourceLocation name;
        private int weight;
        private int minimumYield;
        private int maximumYield;
        private int depletionAmount;
        private int depletionChance = 1;
        private int depletedYield;
        private Supplier<Fluid> fluid;
        private Set<ResourceKey<Level>> dimensions;
        private final List<BiomeWeightModifier> biomes = new LinkedList<BiomeWeightModifier>();

        private Builder(ResourceLocation name) {
            this.name = name;
        }

        public Builder copy(ResourceLocation name) {
            Builder copied = new Builder(name);
            copied.weight = this.weight;
            copied.minimumYield = this.minimumYield;
            copied.maximumYield = this.maximumYield;
            copied.depletionAmount = this.depletionAmount;
            copied.depletionChance = this.depletionChance;
            copied.depletedYield = this.depletedYield;
            copied.fluid = this.fluid;
            return copied;
        }

        public Builder yield(int min, int max) {
            return this.minimumYield(min).maximumYield(max);
        }

        public Builder biomes(int weight, TagKey<Biome> biomes) {
            this.biomes.add(new BiomeWeightModifier(() -> GTRegistries.builtinRegistry().m_175515_(Registries.f_256952_).m_203561_(biomes), weight));
            return this;
        }

        @SafeVarargs
        public final Builder biomes(int weight, ResourceKey<Biome> ... biomes) {
            this.biomes.add(new BiomeWeightModifier(() -> HolderSet.m_205806_(arg_0 -> ((Registry)GTRegistries.builtinRegistry().m_175515_(Registries.f_256952_)).m_246971_(arg_0), (Object[])biomes), weight));
            return this;
        }

        public Builder biomes(int weight, HolderSet<Biome> biomes) {
            this.biomes.add(new BiomeWeightModifier(() -> biomes, weight));
            return this;
        }

        @HideFromJS
        public Builder dimensions(Set<ResourceKey<Level>> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder dimensions(String ... dimensions) {
            return this.dimensions(new HashSet<ResourceKey<Level>>(RegistryUtil.resolveResourceKeys(Registries.f_256858_, dimensions)));
        }

        @ApiStatus.Internal
        public BedrockFluidDefinition build() {
            return new BedrockFluidDefinition(this.weight, this.minimumYield, this.maximumYield, this.depletionAmount, this.depletionChance, this.depletedYield, this.fluid, this.biomes, this.dimensions);
        }

        public BedrockFluidDefinition register() {
            BedrockFluidDefinition definition = this.build();
            GTRegistries.BEDROCK_FLUID_DEFINITIONS.registerOrOverride(this.name, definition);
            return definition;
        }

        @Generated
        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        @Generated
        public Builder minimumYield(int minimumYield) {
            this.minimumYield = minimumYield;
            return this;
        }

        @Generated
        public Builder maximumYield(int maximumYield) {
            this.maximumYield = maximumYield;
            return this;
        }

        @Generated
        public Builder depletionAmount(int depletionAmount) {
            this.depletionAmount = depletionAmount;
            return this;
        }

        @Generated
        public Builder depletionChance(int depletionChance) {
            this.depletionChance = depletionChance;
            return this;
        }

        @Generated
        public Builder depletedYield(int depletedYield) {
            this.depletedYield = depletedYield;
            return this;
        }

        @Generated
        public Builder fluid(Supplier<Fluid> fluid) {
            this.fluid = fluid;
            return this;
        }
    }
}

