/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.tag;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

public class TagType {
    private final String tagPath;
    private boolean isParentTag = false;
    private BiFunction<TagPrefix, Material, TagKey<Item>> formatter;
    private Predicate<Material> filter;

    private TagType(String tagPath) {
        this.tagPath = tagPath;
    }

    public static TagType withDefaultFormatter(String tagPath, boolean isVanilla) {
        TagType type = new TagType(tagPath);
        type.formatter = (prefix, mat) -> TagUtil.createItemTag(type.tagPath.formatted(mat.getName()), isVanilla);
        return type;
    }

    public static TagType withPrefixFormatter(String tagPath) {
        TagType type = new TagType(tagPath);
        type.formatter = (prefix, mat) -> TagUtil.createItemTag(type.tagPath.formatted(FormattingUtil.toLowerCaseUnderscore(prefix.name), mat.getName()));
        return type;
    }

    public static TagType withPrefixOnlyFormatter(String tagPath) {
        TagType type = new TagType(tagPath);
        type.formatter = (prefix, mat) -> TagUtil.createItemTag(type.tagPath.formatted(FormattingUtil.toLowerCaseUnderscore(prefix.name)));
        type.isParentTag = true;
        return type;
    }

    public static TagType withNoFormatter(String tagPath, boolean isVanilla) {
        TagType type = new TagType(tagPath);
        type.formatter = (prefix, material) -> TagUtil.createItemTag(type.tagPath, isVanilla);
        type.isParentTag = true;
        return type;
    }

    public static TagType withCustomFormatter(String tagPath, BiFunction<TagPrefix, Material, TagKey<Item>> formatter) {
        TagType type = new TagType(tagPath);
        type.formatter = formatter;
        return type;
    }

    public static TagType withCustomFilter(String tagPath, boolean isVanilla, Predicate<Material> filter) {
        TagType type = new TagType(tagPath);
        type.filter = filter;
        type.formatter = (prefix, material) -> TagUtil.createItemTag(type.tagPath, isVanilla);
        return type;
    }

    public TagKey<Item> getTag(TagPrefix prefix, Material material) {
        if (this.filter != null && material != null && !this.filter.test(material)) {
            return null;
        }
        return this.formatter.apply(prefix, material);
    }

    @Generated
    public boolean isParentTag() {
        return this.isParentTag;
    }
}

