/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data;

import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.integration.kjs.Validator;
import com.gregtechceu.gtceu.utils.SupplierMemoizer;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class DimensionMarker {
    public static final int MAX_TIER = 99;
    public final int tier;
    @Nullable
    private final String overrideName;
    private final SupplierMemoizer.MemoizedSupplier<ItemStack> iconSupplier;

    public DimensionMarker(int tier, ResourceLocation itemKey, @Nullable String overrideName) {
        this.tier = tier;
        this.overrideName = overrideName;
        this.iconSupplier = SupplierMemoizer.memoize(() -> ForgeRegistries.ITEMS.getDelegate(itemKey).map(Holder::get).map(this::getStack).orElse(ItemStack.f_41583_));
    }

    public DimensionMarker(int tier, Supplier<? extends ItemLike> supplier, @Nullable String overrideName) {
        this.tier = tier;
        this.overrideName = overrideName;
        this.iconSupplier = SupplierMemoizer.memoize(() -> this.getStack(((ItemLike)supplier.get()).m_5456_()));
    }

    public ItemStack getIcon() {
        return this.iconSupplier.get();
    }

    public void register(ResourceLocation dimKey) {
        if (this.tier < 0 || this.tier >= 99) {
            throw new IllegalArgumentException("Tier must be between 0 and 98");
        }
        GTRegistries.DIMENSION_MARKERS.register(dimKey, this);
    }

    private ItemStack getStack(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        if (this.overrideName != null) {
            stack.m_41714_((Component)Component.m_237115_((String)this.overrideName));
        }
        return stack;
    }

    @Generated
    public int getTier() {
        return this.tier;
    }

    @Nullable
    @Generated
    public String getOverrideName() {
        return this.overrideName;
    }

    public static class Builder
    extends BuilderBase<DimensionMarker> {
        private Supplier<Item> iconSupplier;
        private int tier = 0;
        @Nullable
        private String overrideName;

        public Builder(ResourceLocation dimKey) {
            super(dimKey);
        }

        public Builder(ResourceLocation dimKey, Object ... args) {
            this(dimKey);
        }

        @HideFromJS
        public DimensionMarker buildAndRegister() {
            Validator.validate(this.id, Validator.errorIfNull(this.iconSupplier, "icon"), Validator.errorIfOutOfRange(this.tier, "tier", 0, 98));
            DimensionMarker marker = new DimensionMarker(this.tier, this.iconSupplier, this.overrideName);
            marker.register(this.id);
            return marker;
        }

        @Override
        public DimensionMarker register() {
            this.value = this.buildAndRegister();
            return this.value;
        }

        @Generated
        public Builder iconSupplier(Supplier<Item> iconSupplier) {
            this.iconSupplier = iconSupplier;
            return this;
        }

        @Generated
        public Builder tier(int tier) {
            this.tier = tier;
            return this;
        }

        @Generated
        public Builder overrideName(@Nullable String overrideName) {
            this.overrideName = overrideName;
            return this;
        }
    }
}

