/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.content.SerializerLong;
import com.gregtechceu.gtceu.utils.GTMath;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class EURecipeCapability
extends RecipeCapability<Long> {
    public static final EURecipeCapability CAP = new EURecipeCapability();

    protected EURecipeCapability() {
        super("eu", -256, false, 2, SerializerLong.INSTANCE);
    }

    @Override
    public Long copyInner(Long content) {
        return content;
    }

    @Override
    public Long copyWithModifier(Long content, ContentModifier modifier) {
        return modifier.apply(content);
    }

    @Override
    public List<Object> compressIngredients(Collection<Object> ingredients) {
        return List.of(ingredients.stream().map(Long.class::cast).reduce(0L, Long::sum));
    }

    @Override
    public int limitParallel(GTRecipe recipe, IRecipeCapabilityHolder holder, int multiplier) {
        if (holder instanceof ICustomParallel) {
            ICustomParallel p = (ICustomParallel)((Object)holder);
            return p.limitParallel(recipe, multiplier);
        }
        long maxVoltage = Long.MAX_VALUE;
        if (holder instanceof IOverclockMachine) {
            IOverclockMachine overclockMachine = (IOverclockMachine)((Object)holder);
            maxVoltage = overclockMachine.getOverclockVoltage();
        } else if (holder instanceof ITieredMachine) {
            ITieredMachine tieredMachine = (ITieredMachine)((Object)holder);
            maxVoltage = tieredMachine.getMaxVoltage();
        }
        long recipeEUt = RecipeHelper.getOutputEUt(recipe);
        if (recipeEUt == 0L) {
            return Integer.MAX_VALUE;
        }
        return Math.abs(GTMath.saturatedCast(maxVoltage / recipeEUt));
    }

    @Override
    public int getMaxParallelRatio(IRecipeCapabilityHolder holder, GTRecipe recipe, int parallelAmount) {
        long maxVoltage = Long.MAX_VALUE;
        if (holder instanceof IOverclockMachine) {
            IOverclockMachine overclockMachine = (IOverclockMachine)((Object)holder);
            maxVoltage = overclockMachine.getOverclockVoltage();
        } else if (holder instanceof ITieredMachine) {
            ITieredMachine tieredMachine = (ITieredMachine)((Object)holder);
            maxVoltage = tieredMachine.getMaxVoltage();
        }
        long recipeEUt = RecipeHelper.getInputEUt(recipe);
        if (recipeEUt == 0L) {
            return Integer.MAX_VALUE;
        }
        return Math.abs(GTMath.saturatedCast(maxVoltage / recipeEUt));
    }

    public static List<Content> makeEUContent(Long eu) {
        return List.of(new Content(eu, ChanceLogic.getMaxChancedValue(), ChanceLogic.getMaxChancedValue(), 0, null, null));
    }

    public static void putEUContent(Map<RecipeCapability<?>, List<Content>> contents, long eu) {
        contents.put(CAP, EURecipeCapability.makeEUContent(eu));
    }

    public static interface ICustomParallel {
        public int limitParallel(GTRecipe var1, int var2);
    }
}

