/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.block;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICoilType {
    public static final Lazy<ICoilType[]> ALL_COILS_TEMPERATURE_SORTED = Lazy.of(() -> (ICoilType[])GTCEuAPI.HEATING_COILS.keySet().stream().sorted(Comparator.comparing(ICoilType::getCoilTemperature)).toArray(ICoilType[]::new));

    @NotNull
    public String getName();

    public int getCoilTemperature();

    public int getLevel();

    public int getEnergyDiscount();

    public int getTier();

    @Nullable
    public Material getMaterial();

    public ResourceLocation getTexture();

    @Nullable
    public static ICoilType getMinRequiredType(int requiredTemperature) {
        return Arrays.stream((ICoilType[])ALL_COILS_TEMPERATURE_SORTED.get()).filter(coil -> coil.getCoilTemperature() >= requiredTemperature).findFirst().orElse(null);
    }
}

