/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.utils.translate;

import com.black_dog20.bml.utils.text.TextUtil;
import com.black_dog20.bml.utils.translate.ITranslation;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class TranslationUtil {
    public static String translateToString(ITranslation translation) {
        return TextUtil.getFormattedText((Component)TranslationUtil.translate(translation));
    }

    public static String translateToString(ITranslation translation, ChatFormatting color) {
        return TextUtil.getFormattedText((Component)TranslationUtil.translate(translation, color));
    }

    public static String translateToString(ITranslation translation, Object ... objs) {
        return TextUtil.getFormattedText((Component)TranslationUtil.translate(translation, objs));
    }

    public static String translateToString(ITranslation translation, ChatFormatting color, Object ... objs) {
        return TextUtil.getFormattedText((Component)TranslationUtil.translate(translation, color, objs));
    }

    public static MutableComponent translate(ITranslation translation) {
        return TranslationUtil.translate(translation, ChatFormatting.WHITE);
    }

    public static MutableComponent translate(ITranslation translation, Object ... objs) {
        return TranslationUtil.translate(translation, ChatFormatting.WHITE, objs);
    }

    public static MutableComponent translate(ITranslation translation, ChatFormatting color) {
        MutableComponent component = Component.m_237115_((String)String.format("%s.%s", translation.getModId(), translation.getKey()));
        component.m_6270_(component.m_7383_().m_131140_(color));
        return component;
    }

    public static MutableComponent translate(ITranslation translation, ChatFormatting color, Object ... objs) {
        MutableComponent component = Component.m_237110_((String)String.format("%s.%s", translation.getModId(), translation.getKey()), (Object[])objs);
        component.m_6270_(component.m_7383_().m_131140_(color));
        return component;
    }

    public static String translateResourceLocation(ResourceLocation resourceLocation, Function<ResourceLocation, String> defaultFunc) {
        String s = TextUtil.getFormattedText((Component)Component.m_237115_((String)resourceLocation.toString()));
        if (s.contains(resourceLocation.m_135827_())) {
            return resourceLocation.toString();
        }
        return s;
    }

    public static Component createPossibleEagerTranslation(Component translation, boolean translateOnClient) {
        return translateOnClient ? translation : TranslationUtil.eagerTranslate(translation);
    }

    public static Component eagerTranslate(Component component) {
        if (component instanceof MutableComponent) {
            MutableComponent translation = (MutableComponent)component;
            ComponentContents componentContents = translation.m_214077_();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents contents = (TranslatableContents)componentContents;
                Object[] newArgs = Arrays.stream(contents.m_237523_()).map(TranslationUtil::eagerEvaluateArg).toArray();
                MutableComponent result = Component.m_237110_((String)Language.m_128107_().m_6834_(contents.m_237508_()), (Object[])newArgs);
                result.m_6270_(component.m_7383_());
                component.m_7360_().stream().map(TranslationUtil::eagerEvaluateSiblings).forEachOrdered(arg_0 -> ((MutableComponent)result).m_7220_(arg_0));
                return TranslationUtil.eagerEvaluateStyle(result);
            }
            return TranslationUtil.eagerEvaluateStyle(translation);
        }
        return component;
    }

    private static Object eagerEvaluateArg(Object arg) {
        if (arg instanceof MutableComponent) {
            MutableComponent translatableComponent = (MutableComponent)arg;
            return TranslationUtil.eagerTranslate((Component)translatableComponent);
        }
        return arg;
    }

    private static Component eagerEvaluateSiblings(Component sibling) {
        if (sibling instanceof MutableComponent) {
            MutableComponent translatableComponent = (MutableComponent)sibling;
            return TranslationUtil.eagerTranslate((Component)translatableComponent);
        }
        return sibling;
    }

    private static <T extends MutableComponent> T eagerEvaluateStyle(T component) {
        Component hoverText;
        Style style = component.m_7383_();
        HoverEvent hover = style.m_131186_();
        if (hover != null && hover.m_130820_() == HoverEvent.Action.f_130831_ && (hoverText = (Component)hover.m_130823_(HoverEvent.Action.f_130831_)) instanceof MutableComponent) {
            style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)TranslationUtil.eagerTranslate(hoverText)));
        }
        component.m_6270_(style);
        return component;
    }
}

