/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.utils.player;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractPlayerPermissions {
    private String uuid;
    private String displayName;
    private Set<String> permissions;

    public AbstractPlayerPermissions(String uuid, String displayName, IPermission ... permissions) {
        this.uuid = uuid;
        this.displayName = displayName;
        this.permissions = new HashSet<IPermission>(Arrays.asList(permissions)).stream().map(IPermission::getName).collect(Collectors.toSet());
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void grant(IPermission permission) {
        this.permissions.add(permission.getName());
    }

    public void revoke(IPermission permission) {
        this.permissions.remove(permission.getName());
    }

    public boolean hasPermission(IPermission permission) {
        return this.permissions.contains(permission.getName());
    }

    public abstract void onReceiveClientMessage();

    public static interface IPermission {
        public String getName();
    }
}

