/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.utils.math;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Pos3D
extends Vec3 {
    public Pos3D() {
        this(0.0, 0.0, 0.0);
    }

    public Pos3D(Vec3 vec) {
        super(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public Pos3D(Vec3i vec) {
        super((double)vec.m_123341_(), (double)vec.m_123342_(), (double)vec.m_123343_());
    }

    public Pos3D(double x, double y, double z) {
        super(x, y, z);
    }

    public Pos3D(Entity entity) {
        this(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }

    public Pos3D(BlockEntity tile) {
        this((Vec3i)tile.m_58899_());
    }

    public static Pos3D read(CompoundTag tag) {
        return new Pos3D(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"));
    }

    public static Pos3D fromMotion(Entity entity) {
        return new Pos3D(entity.m_20184_());
    }

    public static Pos3D translateMatrix(double[] matrix, Pos3D translation) {
        double x = translation.m_7096_() * matrix[0] + translation.m_7098_() * matrix[1] + translation.m_7094_() * matrix[2] + matrix[3];
        double y = translation.m_7096_() * matrix[4] + translation.m_7098_() * matrix[5] + translation.m_7094_() * matrix[6] + matrix[7];
        double z = translation.m_7096_() * matrix[8] + translation.m_7098_() * matrix[9] + translation.m_7094_() * matrix[10] + matrix[11];
        return new Pos3D(x, y, z);
    }

    public static double[] getRotationMatrix(float angle, Pos3D axis) {
        return axis.getRotationMatrix(angle);
    }

    public static double anglePreNorm(Pos3D pos1, Pos3D pos2) {
        return Math.acos(pos1.m_82526_(pos2));
    }

    public static AABB getAABB(Pos3D pos1, Pos3D pos2) {
        return new AABB(pos1.f_82479_, pos1.f_82480_, pos1.f_82481_, pos2.f_82479_, pos2.f_82480_, pos2.f_82481_);
    }

    public CompoundTag write(CompoundTag nbtTags) {
        nbtTags.m_128347_("x", this.f_82479_);
        nbtTags.m_128347_("y", this.f_82480_);
        nbtTags.m_128347_("z", this.f_82481_);
        return nbtTags;
    }

    public Pos3D diff(Vec3 vec) {
        return new Pos3D(this.f_82479_ - vec.f_82479_, this.f_82480_ - vec.f_82480_, this.f_82481_ - vec.f_82481_);
    }

    public Pos3D centre() {
        return this.translate(0.5, 0.5, 0.5);
    }

    public Pos3D translate(double x, double y, double z) {
        return new Pos3D(this.f_82479_ + x, this.f_82480_ + y, this.f_82481_ + z);
    }

    public Pos3D translate(Vec3 pos) {
        return this.translate(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public Pos3D translate(Direction direction, double amount) {
        return this.translate((double)direction.m_122436_().m_123341_() * amount, (double)direction.m_122436_().m_123342_() * amount, (double)direction.m_122436_().m_123343_() * amount);
    }

    public Pos3D translateExcludingSide(Direction direction, double amount) {
        double xPos = this.f_82479_;
        double yPos = this.f_82480_;
        double zPos = this.f_82481_;
        if (direction.m_122434_() != Direction.Axis.X) {
            xPos += amount;
        }
        if (direction.m_122434_() != Direction.Axis.Y) {
            yPos += amount;
        }
        if (direction.m_122434_() != Direction.Axis.Z) {
            zPos += amount;
        }
        return new Pos3D(xPos, yPos, zPos);
    }

    public double distance(Vec3 pos) {
        double subX = this.f_82479_ - pos.f_82479_;
        double subY = this.f_82480_ - pos.f_82480_;
        double subZ = this.f_82481_ - pos.f_82481_;
        return Math.sqrt(subX * subX + subY * subY + subZ * subZ);
    }

    @Nonnull
    public Pos3D yRot(float yaw) {
        double yawRadians = Math.toRadians(yaw);
        double xPos = this.f_82479_;
        double zPos = this.f_82481_;
        if (yaw != 0.0f) {
            xPos = this.f_82479_ * Math.cos(yawRadians) - this.f_82481_ * Math.sin(yawRadians);
            zPos = this.f_82481_ * Math.cos(yawRadians) + this.f_82479_ * Math.sin(yawRadians);
        }
        return new Pos3D(xPos, this.f_82480_, zPos);
    }

    @Nonnull
    public Pos3D xRot(float pitch) {
        double pitchRadians = Math.toRadians(pitch);
        double yPos = this.f_82480_;
        double zPos = this.f_82481_;
        if (pitch != 0.0f) {
            yPos = this.f_82480_ * Math.cos(pitchRadians) - this.f_82481_ * Math.sin(pitchRadians);
            zPos = this.f_82481_ * Math.cos(pitchRadians) + this.f_82480_ * Math.sin(pitchRadians);
        }
        return new Pos3D(this.f_82479_, yPos, zPos);
    }

    public Pos3D rotate(float yaw, float pitch) {
        return this.rotate(yaw, pitch, 0.0f);
    }

    public Pos3D rotate(float yaw, float pitch, float roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double xPos = this.f_82479_ * Math.cos(yawRadians) * Math.cos(pitchRadians) + this.f_82481_ * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + this.f_82480_ * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        double zPos = this.f_82479_ * Math.sin(yawRadians) * Math.cos(pitchRadians) + this.f_82481_ * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + this.f_82480_ * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        double yPos = -this.f_82479_ * Math.sin(pitchRadians) + this.f_82481_ * Math.cos(pitchRadians) * Math.sin(rollRadians) + this.f_82480_ * Math.cos(pitchRadians) * Math.cos(rollRadians);
        return new Pos3D(xPos, yPos, zPos);
    }

    public Pos3D multiply(Vec3 pos) {
        return this.scale(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public Pos3D scale(double x, double y, double z) {
        return new Pos3D(this.f_82479_ * x, this.f_82480_ * y, this.f_82481_ * z);
    }

    @Nonnull
    public Pos3D scale(double scale) {
        return this.scale(scale, scale, scale);
    }

    public Pos3D rotate(float angle, Pos3D axis) {
        return Pos3D.translateMatrix(Pos3D.getRotationMatrix(angle, axis), this);
    }

    public double[] getRotationMatrix(float angle) {
        double[] matrix = new double[16];
        Pos3D axis = this.clone().normalize();
        double x = axis.f_82479_;
        double y = axis.f_82480_;
        double z = axis.f_82481_;
        double angleAsRadian = Math.toRadians(angle);
        float cos = (float)Math.cos(angleAsRadian);
        float ocos = 1.0f - cos;
        float sin = (float)Math.sin(angleAsRadian);
        matrix[0] = x * x * (double)ocos + (double)cos;
        matrix[1] = y * x * (double)ocos + z * (double)sin;
        matrix[2] = x * z * (double)ocos - y * (double)sin;
        matrix[4] = x * y * (double)ocos - z * (double)sin;
        matrix[5] = y * y * (double)ocos + (double)cos;
        matrix[6] = y * z * (double)ocos + x * (double)sin;
        matrix[8] = x * z * (double)ocos + y * (double)sin;
        matrix[9] = y * z * (double)ocos - x * (double)sin;
        matrix[10] = z * z * (double)ocos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public double anglePreNorm(Pos3D pos2) {
        return Math.acos(this.m_82526_(pos2));
    }

    @Nonnull
    public Pos3D normalize() {
        return new Pos3D(super.m_82541_());
    }

    public Pos3D xCrossProduct() {
        return new Pos3D(0.0, this.f_82481_, -this.f_82480_);
    }

    public Pos3D zCrossProduct() {
        return new Pos3D(-this.f_82480_, this.f_82479_, 0.0);
    }

    public Pos3D getPerpendicular() {
        return this.f_82481_ == 0.0 ? this.zCrossProduct() : this.xCrossProduct();
    }

    public Pos3D floor() {
        return new Pos3D(Math.floor(this.f_82479_), Math.floor(this.f_82480_), Math.floor(this.f_82481_));
    }

    public Pos3D clone() {
        return new Pos3D(this.f_82479_, this.f_82480_, this.f_82481_);
    }

    @Nonnull
    public String toString() {
        return "[Pos3D: " + this.f_82479_ + ", " + this.f_82480_ + ", " + this.f_82481_ + "]";
    }

    public boolean equals(Object obj) {
        return obj instanceof Vec3 && ((Vec3)obj).f_82479_ == this.f_82479_ && ((Vec3)obj).f_82480_ == this.f_82480_ && ((Vec3)obj).f_82481_ == this.f_82481_;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + Double.valueOf(this.f_82479_).hashCode();
        code = 31 * code + Double.valueOf(this.f_82480_).hashCode();
        code = 31 * code + Double.valueOf(this.f_82481_).hashCode();
        return code;
    }
}

