/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.utils.leveling;

import com.black_dog20.bml.api.ILevelableItem;
import com.black_dog20.bml.internal.utils.InternalTranslations;
import com.black_dog20.bml.utils.item.NBTUtil;
import com.black_dog20.bml.utils.text.TextComponentBuilder;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemLevelProperties {
    public static final String TAG_XP = "bml-item-xp";
    public static final String TAG_LEVEL = "bml-item-level";

    public static void addXp(Player player, ItemStack tool, int xp) {
        if (ItemLevelProperties.canLevel(tool)) {
            ILevelableItem levelableItem = (ILevelableItem)tool.m_41720_();
            int currentLevel = ItemLevelProperties.getCurrentLevel(tool);
            int currentXP = ItemLevelProperties.getCurrentXp(tool);
            if (currentLevel == levelableItem.getMaxLevel()) {
                return;
            }
            int nextXp = currentXP + xp;
            int nextLevel = currentLevel;
            int xpForLevelUp = ItemLevelProperties.getXpToNextLevel(tool, currentLevel + 1);
            if (nextXp >= xpForLevelUp) {
                nextXp -= xpForLevelUp;
                ++nextLevel;
            }
            CompoundTag compoundNBT = tool.m_41784_();
            compoundNBT.m_128405_(TAG_XP, nextXp);
            if (currentLevel != nextLevel) {
                boolean wasSoulbound = ItemLevelProperties.isLevelAbovePercentage(levelableItem.getSoulboundLevel(), currentLevel, tool);
                boolean isSoulbound = ItemLevelProperties.isLevelAbovePercentage(levelableItem.getSoulboundLevel(), nextLevel, tool);
                compoundNBT.m_128405_(TAG_LEVEL, nextLevel);
                if (!wasSoulbound && isSoulbound) {
                    player.m_213846_(InternalTranslations.Translations.SOULBOUND_ACHIEVED.get(ChatFormatting.AQUA, new Object[]{tool.m_41786_().getString().toLowerCase()}));
                }
            }
        }
    }

    private static int getXpToNextLevel(ItemStack tool, int level) {
        if (level <= 1) {
            return ItemLevelProperties.getBaseXp(tool);
        }
        return (int)((double)ItemLevelProperties.getXpToNextLevel(tool, level - 1) * ItemLevelProperties.getLevelXpMultiplier(tool));
    }

    public static Component getXpToNextLevel(ItemStack tool) {
        if (!ItemLevelProperties.isLevelable(tool)) {
            return InternalTranslations.Translations.NOT_LEVELABLE.get();
        }
        if (ItemLevelProperties.getCurrentLevel(tool) >= ItemLevelProperties.getMaxLevel(tool)) {
            return InternalTranslations.Translations.MAX_LEVEL.get();
        }
        int level = ItemLevelProperties.getCurrentLevel(tool) + 1;
        int xpToNextLevel = ItemLevelProperties.getXpToNextLevel(tool, level);
        return InternalTranslations.Translations.PROGRESS.get(ChatFormatting.GRAY, new Object[]{ItemLevelProperties.getCurrentLevel(tool), ItemLevelProperties.getCurrentXp(tool), xpToNextLevel});
    }

    public static int getCurrentXp(ItemStack tool) {
        if (!ItemLevelProperties.isLevelable(tool)) {
            return 0;
        }
        return NBTUtil.getInt(tool, TAG_XP);
    }

    public static int getCurrentLevel(ItemStack tool) {
        if (!ItemLevelProperties.isLevelable(tool)) {
            return 0;
        }
        return NBTUtil.getInt(tool, TAG_LEVEL);
    }

    public static boolean isLevelAbovePercentage(double percentage, ItemStack tool) {
        if (!ItemLevelProperties.isLevelable(tool)) {
            return false;
        }
        return ItemLevelProperties.isLevelAbovePercentage(percentage, ItemLevelProperties.getCurrentLevel(tool), tool);
    }

    public static boolean isLevelAbovePercentage(double percentage, int level, ItemStack tool) {
        return ItemLevelProperties.getLevelableItem(tool).map(item -> (double)level >= percentage * (double)item.getMaxLevel()).orElse(false);
    }

    public static double calculateValue(double base, double wantedLevel, ItemStack tool) {
        if (!ItemLevelProperties.isLevelable(tool)) {
            return 0.0;
        }
        ILevelableItem levelableItem = (ILevelableItem)tool.m_41720_();
        if (base < wantedLevel) {
            double gainPerLevel = (wantedLevel - base) / (double)levelableItem.getMaxLevel();
            return base + Math.abs(gainPerLevel * (double)ItemLevelProperties.getCurrentLevel(tool));
        }
        if (base > wantedLevel) {
            double lossPerLevel = (base - wantedLevel) / (double)levelableItem.getMaxLevel();
            return base - Math.abs(lossPerLevel * (double)ItemLevelProperties.getCurrentLevel(tool));
        }
        return base;
    }

    private static boolean canLevel(ItemStack tool) {
        return ItemLevelProperties.getLevelableItem(tool).map(item -> ItemLevelProperties.getCurrentLevel(tool) < item.getMaxLevel()).orElse(false);
    }

    private static int getBaseXp(ItemStack tool) {
        return ItemLevelProperties.getLevelableItem(tool).map(ILevelableItem::getBaseXp).orElse(500);
    }

    private static double getLevelXpMultiplier(ItemStack tool) {
        return ItemLevelProperties.getLevelableItem(tool).map(ILevelableItem::getLevelXpMultiplier).orElse(1.1);
    }

    private static boolean isLevelable(ItemStack tool) {
        return ItemLevelProperties.getLevelableItem(tool).isPresent();
    }

    public static int getMaxLevel(ItemStack tool) {
        return ItemLevelProperties.getLevelableItem(tool).map(ILevelableItem::getMaxLevel).orElse(0);
    }

    private static Optional<ILevelableItem> getLevelableItem(ItemStack tool) {
        return Optional.of(tool).map(ItemStack::m_41720_).filter(ILevelableItem.class::isInstance).map(ILevelableItem.class::cast);
    }

    public static Component getLevelProgress(ItemStack stack) {
        return ItemLevelProperties.getLevelProgress(stack, ChatFormatting.GRAY);
    }

    public static Component getLevelProgress(ItemStack stack, ChatFormatting baseColor) {
        return TextComponentBuilder.of(InternalTranslations.Translations.LEVEL).format(baseColor).with(":").format(baseColor).space().with(ItemLevelProperties.getXpToNextLevel(stack)).build();
    }
}

