/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.utils.file;

import com.black_dog20.bml.Bml;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.storage.LevelResource;

public class FileUtil {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static <T> boolean save(File dir, String fileName, T data, Type type) {
        try {
            dir.mkdirs();
            if (!((String)fileName).startsWith("/")) {
                fileName = "/" + (String)fileName;
            }
            File dataFile = new File(dir.getPath() + (String)fileName);
            FileWriter writer = new FileWriter(dataFile);
            GSON.toJson(data, type, (Appendable)writer);
            writer.close();
            return true;
        }
        catch (Exception e) {
            Bml.getLogger().error("Failed to save " + (String)fileName + " because of " + e.getMessage());
            return false;
        }
    }

    public static <T> T load(File dir, String fileName, Type type, Supplier<T> supplier) {
        try {
            File dataFile;
            dir.mkdirs();
            if (!((String)fileName).startsWith("/")) {
                fileName = "/" + (String)fileName;
            }
            if ((dataFile = new File(dir.getPath() + (String)fileName)).exists()) {
                JsonReader reader = new JsonReader((Reader)new FileReader(dataFile));
                Object data = GSON.fromJson(reader, type);
                if (data == null) {
                    return supplier.get();
                }
                return (T)data;
            }
            return supplier.get();
        }
        catch (Exception e) {
            Bml.getLogger().error("Failed to load " + (String)fileName + " because of " + e.getMessage());
            return supplier.get();
        }
    }

    public static File getDirRelativeToWorldFolder(ServerLevel world, String dirName) {
        Path path = world.m_7654_().m_129843_(LevelResource.f_78182_);
        File dir = path.toFile();
        if (!((String)dirName).startsWith("/")) {
            dirName = "/" + (String)dirName;
        }
        File dirFile = new File(dir.getPath() + (String)dirName);
        dirFile.mkdirs();
        return dirFile;
    }
}

