/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.utils.enchantment;

import com.black_dog20.bml.utils.math.MathUtil;
import com.black_dog20.bml.utils.stream.StreamUtils;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentUtil {
    public static ItemStack addRandomEnchantment(ItemStack stack, boolean allowTreasure, Level level) {
        boolean flag;
        Optional<EnchantmentInstance> enchantmentData = EnchantmentUtil.getRandomEnchantmentData(stack, allowTreasure, level);
        boolean bl = flag = stack.m_41720_() == Items.f_42517_;
        if (flag) {
            stack = new ItemStack((ItemLike)Items.f_42690_);
        }
        if (!enchantmentData.isPresent()) {
            return stack;
        }
        if (flag) {
            EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)enchantmentData.get());
        } else {
            stack.m_41663_(enchantmentData.get().f_44947_, enchantmentData.get().f_44948_);
        }
        return stack;
    }

    private static Optional<EnchantmentInstance> getRandomEnchantmentData(ItemStack stack, boolean allowTreasure, Level level) {
        return ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(EnchantmentUtil.getEnchantmentFilter(stack, allowTreasure)).map(EnchantmentUtil.createEnchantmentData(level)).collect(StreamUtils.toShuffledStream()).limit(1L).findFirst();
    }

    private static Function<Enchantment, EnchantmentInstance> createEnchantmentData(Level level) {
        switch (level) {
            case MIN: {
                return e -> new EnchantmentInstance(e, e.m_44702_());
            }
            case MAX: {
                return e -> new EnchantmentInstance(e, e.m_6586_());
            }
            case RANDOM: {
                return e -> new EnchantmentInstance(e, MathUtil.random(e.m_44702_(), e.m_6586_()));
            }
        }
        throw new UnsupportedOperationException("Got level which is not supported, level = " + level.name());
    }

    private static Predicate<Enchantment> getEnchantmentFilter(ItemStack stack, boolean allowTreasure) {
        boolean flag = stack.m_41720_() == Items.f_42517_;
        return enchantment -> (!enchantment.m_6591_() || allowTreasure) && (enchantment.canApplyAtEnchantingTable(stack) || flag && enchantment.isAllowedOnBooks());
    }

    public static enum Level {
        MIN,
        MAX,
        RANDOM;

    }
}

