/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.utils.dimension;

import com.black_dog20.bml.utils.text.TextUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class DimensionUtil {
    public static MutableComponent getFormattedDimensionName(String dimensionName) {
        if (!dimensionName.contains(".") && !dimensionName.contains(":")) {
            String name = TextUtil.capitaliseFirstLetterFully(dimensionName.replaceAll("_", " "));
            return Component.m_237113_((String)name);
        }
        return Component.m_237113_((String)dimensionName);
    }

    public static MutableComponent getFormattedDimensionName(ResourceKey<Level> dimension) {
        return DimensionUtil.getFormattedDimensionName(dimension.m_211136_(), null);
    }

    public static MutableComponent getFormattedDimensionName(ResourceLocation dimensionName, String fallbackModId) {
        MutableComponent name = Component.m_237115_((String)dimensionName.toString());
        if (name.getString().equals(dimensionName.toString())) {
            String alt = String.format("%s.%s", dimensionName.m_135827_(), dimensionName.m_135815_());
            name = Component.m_237115_((String)alt);
            if (name.getString().equals(alt) && TextUtil.isNotNullOrEmpty(fallbackModId)) {
                String fallback = String.format("%s.%s", fallbackModId, dimensionName.toString());
                name = Component.m_237115_((String)fallback);
                if (name.getString().equals(fallback)) {
                    name = DimensionUtil.getFormattedDimensionName(dimensionName.m_135815_());
                }
            } else {
                name = DimensionUtil.getFormattedDimensionName(dimensionName.m_135815_());
            }
        }
        return name;
    }

    public static ResourceKey<Level> getDimension(Level world) {
        return world.m_46472_();
    }

    public static ResourceLocation getDimensionResourceLocation(Level world) {
        return DimensionUtil.getDimension(world).m_135782_();
    }
}

