/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.utils.color;

import com.black_dog20.bml.utils.color.ColorThief;
import com.black_dog20.bml.utils.math.MathUtil;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;

public final class ColorUtil {
    public static int getColor(Fluid fluid) {
        if (fluid == Fluids.f_76193_) {
            return 38143;
        }
        TextureAtlasSprite[] sprites = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)Minecraft.m_91087_().f_91073_, (BlockPos)BlockPos.f_121853_, (FluidState)fluid.m_76145_());
        if (sprites.length > 0) {
            return ColorUtil.getColor(sprites[0]);
        }
        return 0xFFFFFF;
    }

    public static int getColor(TextureAtlasSprite sprite) {
        List<Integer> colors = ColorUtil.getColors(sprite, 0xFFFFFF, 1);
        return colors.isEmpty() ? 0xFFFFFF : colors.get(0);
    }

    private static List<Integer> getColors(TextureAtlasSprite textureAtlasSprite, int renderColor, int colorCount) {
        NativeImage bufferedImage = ColorUtil.getNativeImage(textureAtlasSprite);
        if (bufferedImage == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> colors = new ArrayList<Integer>(colorCount);
        int[][] palette = ColorThief.getPalette(bufferedImage, colorCount, 2, false);
        if (palette != null) {
            int[][] var6 = palette;
            int var7 = palette.length;
            for (int var8 = 0; var8 < var7; ++var8) {
                int[] colorInt = var6[var8];
                int red = (int)((float)(colorInt[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
                int green = (int)((float)(colorInt[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
                int blue = (int)((float)(colorInt[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
                red = MathUtil.clamp(red, 0, 255);
                green = MathUtil.clamp(green, 0, 255);
                blue = MathUtil.clamp(blue, 0, 255);
                int color = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                colors.add(color);
            }
        }
        return colors;
    }

    @Nullable
    private static NativeImage getNativeImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.m_245424_().m_246492_();
        int iconHeight = textureAtlasSprite.m_245424_().m_245330_();
        if (iconWidth <= 0 || iconHeight <= 0) {
            return null;
        }
        NativeImage[] frames = textureAtlasSprite.m_245424_().f_243731_;
        if (frames.length == 0) {
            return null;
        }
        return frames[0];
    }
}

