/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.internal.utils;

import com.black_dog20.bml.api.ISoulbindable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SoulBoundInventory {
    private static String SOULBOUND_INVENTORY_TAG = "bml-soulbound-inventory";
    public final NonNullList<ItemStack> mainInventory;
    public final NonNullList<ItemStack> armorInventory;
    public final NonNullList<ItemStack> offHandInventory;
    public final Player player;

    private SoulBoundInventory(Player player, boolean load) {
        this.player = player;
        this.mainInventory = NonNullList.m_122780_((int)player.m_150109_().f_35974_.size(), (Object)ItemStack.f_41583_);
        this.armorInventory = NonNullList.m_122780_((int)player.m_150109_().f_35975_.size(), (Object)ItemStack.f_41583_);
        this.offHandInventory = NonNullList.m_122780_((int)player.m_150109_().f_35976_.size(), (Object)ItemStack.f_41583_);
        if (load) {
            this.readFromNBT();
        } else {
            this.copyMain();
            this.copyArmor();
            this.copyOffHand();
        }
    }

    public SoulBoundInventory(Player player) {
        this(player, false);
    }

    public static SoulBoundInventory GetForPlayer(Player player) {
        return new SoulBoundInventory(player, true);
    }

    private boolean isSoulbound(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_41720_() instanceof ISoulbindable && ((ISoulbindable)itemStack.m_41720_()).isSoulbound(itemStack);
    }

    private void copyMain() {
        NonNullList old = this.player.m_150109_().f_35974_;
        for (int i = 0; i < old.size(); ++i) {
            ItemStack itemStack = (ItemStack)old.get(i);
            if (!this.isSoulbound(itemStack)) continue;
            this.mainInventory.set(i, (Object)((ItemStack)old.get(i)).m_41777_());
            ((ItemStack)old.get(i)).m_41764_(0);
        }
    }

    private void copyArmor() {
        NonNullList old = this.player.m_150109_().f_35975_;
        for (int i = 0; i < old.size(); ++i) {
            ItemStack itemStack = (ItemStack)old.get(i);
            if (!this.isSoulbound(itemStack)) continue;
            this.armorInventory.set(i, (Object)((ItemStack)old.get(i)).m_41777_());
            ((ItemStack)old.get(i)).m_41764_(0);
        }
    }

    private void copyOffHand() {
        NonNullList old = this.player.m_150109_().f_35976_;
        for (int i = 0; i < old.size(); ++i) {
            ItemStack itemStack = (ItemStack)old.get(i);
            if (!this.isSoulbound(itemStack)) continue;
            this.offHandInventory.set(i, (Object)((ItemStack)old.get(i)));
            ((ItemStack)old.get(i)).m_41764_(0);
        }
    }

    public void restoreMain(Player player) {
        NonNullList<ItemStack> old = this.mainInventory;
        for (int i = 0; i < old.size(); ++i) {
            ItemStack itemStack = (ItemStack)old.get(i);
            if (!this.isSoulbound(itemStack)) continue;
            player.m_150109_().f_35974_.set(i, (Object)((ItemStack)old.get(i)).m_41777_());
            ((ItemStack)old.get(i)).m_41764_(0);
        }
    }

    public void restoreArmor(Player player) {
        NonNullList<ItemStack> old = this.armorInventory;
        for (int i = 0; i < old.size(); ++i) {
            ItemStack itemStack = (ItemStack)old.get(i);
            if (!this.isSoulbound(itemStack)) continue;
            player.m_150109_().f_35975_.set(i, (Object)((ItemStack)old.get(i)).m_41777_());
            ((ItemStack)old.get(i)).m_41764_(0);
        }
    }

    public void restoreHand(Player player) {
        NonNullList<ItemStack> old = this.offHandInventory;
        for (int i = 0; i < old.size(); ++i) {
            ItemStack itemStack = (ItemStack)old.get(i);
            if (!this.isSoulbound(itemStack)) continue;
            player.m_150109_().f_35976_.set(i, (Object)((ItemStack)old.get(i)));
            ((ItemStack)old.get(i)).m_41764_(0);
        }
    }

    public void writeToNBT() {
        ListTag nbtTagListIn = new ListTag();
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (((ItemStack)this.mainInventory.get(i)).m_41619_()) continue;
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.m_128344_("Slot", (byte)i);
            ((ItemStack)this.mainInventory.get(i)).m_41739_(nbttagcompound);
            nbtTagListIn.add((Object)nbttagcompound);
        }
        for (int j = 0; j < this.armorInventory.size(); ++j) {
            if (((ItemStack)this.armorInventory.get(j)).m_41619_()) continue;
            CompoundTag nbttagcompound1 = new CompoundTag();
            nbttagcompound1.m_128344_("Slot", (byte)(j + 100));
            ((ItemStack)this.armorInventory.get(j)).m_41739_(nbttagcompound1);
            nbtTagListIn.add((Object)nbttagcompound1);
        }
        for (int k = 0; k < this.offHandInventory.size(); ++k) {
            if (((ItemStack)this.offHandInventory.get(k)).m_41619_()) continue;
            CompoundTag nbttagcompound2 = new CompoundTag();
            nbttagcompound2.m_128344_("Slot", (byte)(k + 150));
            ((ItemStack)this.offHandInventory.get(k)).m_41739_(nbttagcompound2);
            nbtTagListIn.add((Object)nbttagcompound2);
        }
        this.player.getPersistentData().m_128365_(SOULBOUND_INVENTORY_TAG, (Tag)nbtTagListIn);
    }

    public void readFromNBT() {
        this.mainInventory.clear();
        this.armorInventory.clear();
        this.offHandInventory.clear();
        ListTag nbtTagListIn = (ListTag)this.player.getPersistentData().m_128423_(SOULBOUND_INVENTORY_TAG);
        if (nbtTagListIn != null) {
            for (int i = 0; i < nbtTagListIn.size(); ++i) {
                CompoundTag nbttagcompound = nbtTagListIn.m_128728_(i);
                int j = nbttagcompound.m_128445_("Slot") & 0xFF;
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)nbttagcompound);
                if (itemstack.m_41619_()) continue;
                if (j >= 0 && j < this.mainInventory.size()) {
                    this.mainInventory.set(j, (Object)itemstack);
                    continue;
                }
                if (j >= 100 && j < this.armorInventory.size() + 100) {
                    this.armorInventory.set(j - 100, (Object)itemstack);
                    continue;
                }
                if (j < 150 || j >= this.offHandInventory.size() + 150) continue;
                this.offHandInventory.set(j - 150, (Object)itemstack);
            }
        }
    }

    public void clear() {
        this.player.getPersistentData().m_128473_(SOULBOUND_INVENTORY_TAG);
    }

    public boolean addItemStackToInventory(ItemStack stack) {
        int i = this.getFirstStackWhichCanMerge(stack);
        if (i == -1) {
            i = this.getFirstEmptyStack();
            if (i == -1) {
                return false;
            }
            this.mainInventory.set(i, (Object)stack);
            return true;
        }
        this.mainInventory.set(i, (Object)stack);
        return true;
    }

    public int getFirstEmptyStack() {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (!((ItemStack)this.mainInventory.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public int getFirstStackWhichCanMerge(ItemStack stack) {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (((ItemStack)this.mainInventory.get(i)).m_41720_() != stack.m_41720_() || ((ItemStack)this.mainInventory.get(i)).m_41741_() < ((ItemStack)this.mainInventory.get(i)).m_41613_() + stack.m_41613_()) continue;
            return i;
        }
        return -1;
    }
}

