/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.internal.event;

import com.black_dog20.bml.event.ArmorEvent;
import com.black_dog20.bml.internal.capability.ArmorInventoryCapability;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blackdogsmoddinglibrary")
public class ArmorEventHandler {
    @SubscribeEvent
    public static void onCapabilitiesEntity(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof Player) {
            evt.addCapability(new ResourceLocation("blackdogsmoddinglibrary", "armor_inventory_capability"), ArmorInventoryCapability.createProvider());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerClone(PlayerEvent.Clone event) {
        LazyOptional oldCap = event.getOriginal().getCapability(ArmorInventoryCapability.CAP);
        LazyOptional newCap = event.getEntity().getCapability(ArmorInventoryCapability.CAP);
        oldCap.ifPresent(o -> newCap.ifPresent(o::copyTo));
        for (ItemStack armor : event.getEntity().m_150109_().f_35975_) {
            if (armor.m_41619_() || event.getEntity().m_9236_().f_46443_) continue;
            MinecraftForge.EVENT_BUS.post((Event)new ArmorEvent.Equip(event.getEntity(), armor));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        for (ItemStack armor : event.getEntity().m_150109_().f_35975_) {
            if (armor.m_41619_() || event.getEntity().m_9236_().f_46443_) continue;
            MinecraftForge.EVENT_BUS.post((Event)new ArmorEvent.Equip(event.getEntity(), armor));
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        LazyOptional capability = event.player.getCapability(ArmorInventoryCapability.CAP);
        capability.ifPresent(cap -> {
            int size = cap.getSize();
            for (int i = 0; i < size; ++i) {
                ItemStack curr;
                ItemStack prev = cap.getStackInSlot(i);
                if (!ItemStack.m_41656_((ItemStack)prev, (ItemStack)(curr = (ItemStack)event.player.m_150109_().f_35975_.get(i)))) {
                    if (!prev.m_41619_() && !event.player.m_9236_().f_46443_) {
                        MinecraftForge.EVENT_BUS.post((Event)new ArmorEvent.Unequip(event.player, prev));
                    }
                    if (!curr.m_41619_() && !event.player.m_9236_().f_46443_) {
                        MinecraftForge.EVENT_BUS.post((Event)new ArmorEvent.Equip(event.player, curr));
                    }
                }
                if (!curr.m_41619_()) {
                    MinecraftForge.EVENT_BUS.post((Event)new ArmorEvent.Tick(event.phase, event.player, curr));
                }
                cap.setStackInSlot(i, curr.m_41777_());
            }
        });
    }
}

