/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.bml.internal.capability;

import com.black_dog20.bml.internal.capability.IArmorInventoryCapability;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class ArmorInventoryCapability
implements IArmorInventoryCapability {
    public static Capability<IArmorInventoryCapability> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IArmorInventoryCapability>(){});
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);

    @Override
    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.inventory.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.inventory.size() + ")");
        }
        return (ItemStack)this.inventory.get(slot);
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.inventory.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.inventory.size() + ")");
        }
        this.inventory.set(slot, (Object)stack);
    }

    @Override
    public void setSize(int size) {
        this.inventory = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    @Override
    public int getSize() {
        return this.inventory.size();
    }

    @Override
    public void copyArmor(NonNullList<ItemStack> armorInventory) {
        int size = armorInventory.size();
        this.inventory = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < size; ++i) {
            this.inventory.set(i, (Object)((ItemStack)armorInventory.get(i)));
        }
    }

    @Override
    public void copyTo(IArmorInventoryCapability other) {
        other.copyArmor(this.inventory);
    }

    @Override
    public CompoundTag writeToNbt() {
        int size = this.getSize();
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < size; ++i) {
            if (this.getStackInSlot(i).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            this.getStackInSlot(i).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Items", (Tag)nbtTagList);
        nbt.m_128405_("Size", size);
        return nbt;
    }

    @Override
    public void readFromNbt(CompoundTag compoundNBT) {
        this.setSize(compoundNBT.m_128425_("Size", 3) ? compoundNBT.m_128451_("Size") : this.getSize());
        int size = this.getSize();
        ListTag tagList = compoundNBT.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= size) continue;
            this.setStackInSlot(slot, ItemStack.m_41712_((CompoundTag)itemTags));
        }
    }

    public static ICapabilityProvider createProvider() {
        return new Provider();
    }

    public static class Provider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        final LazyOptional<IArmorInventoryCapability> optional;
        final IArmorInventoryCapability handler = new ArmorInventoryCapability();

        Provider() {
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return CAP.orEmpty(capability, this.optional);
        }

        public CompoundTag serializeNBT() {
            return this.handler.writeToNbt();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.handler.readFromNbt(nbt);
        }
    }

    public static final class Factory
    implements Callable<ArmorInventoryCapability> {
        @Override
        public ArmorInventoryCapability call() {
            return new ArmorInventoryCapability();
        }
    }
}

